package com.tbyf.his.configuration.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.service.ISysDatasourceService;
import com.tbyf.his.configuration.domain.ImportParam;
import com.tbyf.his.configuration.domain.WsConfigDetail;
import com.tbyf.his.configuration.mapper.WsConfigDetailMapper;
import com.tbyf.his.configuration.service.IWsConfigDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * detailService业务层处理
 *
 * @author guopx
 * @date 2022-04-15
 */
@Service
public class WsConfigDetailServiceImpl implements IWsConfigDetailService {
    @Autowired
    private WsConfigDetailMapper wsConfigDetailMapper;
    @Autowired
    private ISysDatasourceService sysDatasourceService;

    /**
     * 查询detail
     *
     * @param id detail主键
     * @return detail
     */
    @Override
    public WsConfigDetail selectWsConfigDetailById(Long id) {
        return wsConfigDetailMapper.selectWsConfigDetailById(id);
    }

    /**
     * 查询detail列表
     *
     * @param wsConfigDetail detail
     * @return detail
     */
    @Override
    public List<WsConfigDetail> selectWsConfigDetailList(WsConfigDetail wsConfigDetail) {
        return wsConfigDetailMapper.selectWsConfigDetailList(wsConfigDetail);
    }

    /**
     * 新增detail
     *
     * @param wsConfigDetail detail
     * @return 结果
     */
    @Override
    public int insertWsConfigDetail(WsConfigDetail wsConfigDetail) {
        wsConfigDetail.setCreateTime(DateUtils.getNowDate());
        return wsConfigDetailMapper.insertWsConfigDetail(wsConfigDetail);
    }

    /**
     * 修改detail
     *
     * @param wsConfigDetail detail
     * @return 结果
     */
    @Override
    public int updateWsConfigDetail(WsConfigDetail wsConfigDetail) {
        wsConfigDetail.setUpdateTime(DateUtils.getNowDate());
        return wsConfigDetailMapper.updateWsConfigDetail(wsConfigDetail);
    }

    /**
     * 批量删除detail
     *
     * @param ids 需要删除的detail主键
     * @return 结果
     */
    @Override
    public int deleteWsConfigDetailByIds(Long[] ids) {
        return wsConfigDetailMapper.deleteWsConfigDetailByIds(ids);
    }

    /**
     * 删除detail信息
     *
     * @param id detail主键
     * @return 结果
     */
    @Override
    public int deleteWsConfigDetailById(Long id) {
        return wsConfigDetailMapper.deleteWsConfigDetailById(id);
    }

    @Override
    public List<Map<String, Object>> importTargetKey(ImportParam importParam) {
        if (StringUtils.isNull(importParam)) {
            return new ArrayList<>();
        }
        String importType = importParam.getImportType();
        if ("tbName".equals(importType)) {
            Long dsId = importParam.getDsId();
            String tbName = importParam.getTbName();
            SysDatasource ds = sysDatasourceService.selectSysDatasourceByDatasourceId(dsId);
            String driverClass = ds.getDriverClass().toLowerCase();
            String sql = "";
            if (driverClass.contains("oracle")) {
                //通过表名获取字段
                sql = "SELECT COLUMN_NAME \"paramKey\"," +
                        "COLUMN_NAME \"targetKey\", " +
                        "decode(DATA_TYPE,'LONG','number','FLOAT','number','DATE','time','TIMESTAMP(6)','time','string') \"paramType\" " +
                        "FROM USER_TAB_COLUMNS WHERE TABLE_NAME = '" + tbName.toUpperCase() + "'";
            } else if (driverClass.contains("mysql")) {
                sql = "select column_name paramKey," +
                        "column_name targetKey," +
                        "decode(DATA_TYPE,'bigint','number','int','number','double','number','decimal','number','float','number','date','time','timestamp','time','datetime','time','time','time','string') \"paramType\" " +
                        " from information_schema.columns " +
                        "where table_schema = (select database()) and table_name = ('" + tbName + "')\n" +
                        " order by ordinal_position";
            }

            List<Map<String, Object>> list = sysDatasourceService.switchDsAndExecuteSql(dsId, sql);
            return list;
        } else if ("az".equals(importType)) {
            String a = importParam.getA();
            String z = importParam.getZ();
            String source = "abcdefghijklmnopqrstuvwxyz";
            String between = StringUtils.substring(source, source.indexOf(a), source.indexOf(z) + 1);
            List<Map<String, Object>> collect = Stream
                    .iterate(0, n -> ++n)
                    .limit(between.length())
                    .map(n -> {
                        Map<String, Object> m = new HashMap<>();
                        m.put("paramKey", between.charAt(n));
                        m.put("targetKey", between.charAt(n));
                        m.put("paramType", "string");
                        return m;
                    })
                    .collect(Collectors.toList());

            return collect;
        }
        return null;
    }

    @Override
    @Transactional
    public void addDetailList(Long wsConfigId, String xmlFlag, List<WsConfigDetail> detailList) {
        for (int i = 0; i < detailList.size(); i++) {
            WsConfigDetail detail = detailList.get(i);
            detail.setOrderNum(i + 1);
            detail.setWsConfigId(wsConfigId);
            detail.setXmlFlag(xmlFlag);
            insertWsConfigDetail(detail);
        }
    }

    @Override
    public void updateDetailList(List<WsConfigDetail> detailList) {
        detailList.forEach(one -> updateWsConfigDetail(one));
    }

}
