package com.tbyf.his.emport.core;

import com.tbyf.his.emport.constant.EmportConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lzz
 * @date 2023/1/29 13:57
 */

@Configuration
public class EmportConfig {

    @Autowired
    private ApplicationContext applicationContext;

    public static final Map<String, RuleValidator> RULE_VALIDATOR_MAP = new ConcurrentHashMap<>(8);

    @PostConstruct
    public void init() {
        final Map<String, RuleValidator> validatorMap = applicationContext.getBeansOfType(RuleValidator.class);
        RULE_VALIDATOR_MAP.putAll(validatorMap);
    }

    public static RuleValidator getValidator(String mode) {
        return RULE_VALIDATOR_MAP.get(EmportConstants.SERVICE_PREFIX + mode);
    }


}
