package com.tbyf.his.emport.core.validator;

import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportException;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 比较规则校验
 * 目前支持符号为 > >= < <= = !=
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_COMPARE)
public class CompareValidator implements RuleValidator {

    public static final String GT = ">";

    public static final String GTE = ">=";

    public static final String LT = "<";

    public static final String LTE = "<=";

    public static final String EQ = "=";

    public static final String NEQ = "!=";

    @Override
    public boolean validate(RuleContent content) {
        BigDecimal value;
        try {
            value = new BigDecimal(content.getValue());
        } catch (NumberFormatException e) {
            throw new EmportException(content, "数据类型异常:{}", content.getValue());
        }
        if (content.getContent().startsWith(GT)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), GT));
            if (value.compareTo(x) > 0) {
                return true;
            }
        } else if (content.getContent().startsWith(GTE)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), GTE));
            if (value.compareTo(x) >= 0) {
                return true;
            }
        } else if (content.getContent().startsWith(LT)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), LT));
            if (value.compareTo(x) < 0) {
                return true;
            }
        } else if (content.getContent().startsWith(LTE)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), LTE));
            if (value.compareTo(x) <= 0) {
                return true;
            }
        } else if (content.getContent().startsWith(EQ)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), EQ));
            if (value.compareTo(x) == 0) {
                return true;
            }
        } else if (content.getContent().startsWith(NEQ)) {
            final BigDecimal x = new BigDecimal(getValue(content.getContent(), NEQ));

            if (value.compareTo(x) != 0) {
                return true;
            }
        } else {
            throw new EmportException(content, "暂不支持的比较符号:[{}]", content.getContent());
        }
        throw new EmportException(content, "比较规则校验未通过:[{}]", content.getContent());
    }

    private String getValue(String value, String symbol) {
        return value.trim().substring(symbol.length()).trim();
    }
}
