package com.tbyf.his.emport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportException;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import org.springframework.stereotype.Service;

/**
 * 非空规则校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_NOTNULL)
public class NotNullValidator implements RuleValidator {
    @Override
    public boolean validate(RuleContent content) {
        final String[] badArray = content.getContent().split(EmportConstants.SEPARATOR);
        for (String badStr : badArray) {
            if (StringUtils.equals(badStr, content.getValue())) {
                throw new EmportException(content, "非空规则校验未通过:[{}]", content.getContent());
            }
        }
        return true;
    }
}
