package com.tbyf.his.emport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportException;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import org.springframework.stereotype.Service;

/**
 * 值域校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_RANGE)
public class RangeValidator implements RuleValidator {

    @Override
    public boolean validate(RuleContent content) {
        final String[] arr = content.getContent().split(EmportConstants.SEPARATOR);
        for (String value : arr) {
            if (StringUtils.equals(value, content.getValue())) {
                return true;
            }
        }
        throw new EmportException(content, "值域校验未通过:[{}]", content.getContent());
    }

}
