package com.tbyf.his.emport.core.validator;

import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportException;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import org.springframework.stereotype.Service;

import java.util.regex.Pattern;

/**
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_REG)
public class RegValidator implements RuleValidator {
    @Override
    public boolean validate(RuleContent content) {
        final boolean matches = Pattern.matches(content.getContent(), content.getValue());
        if (!matches) {
            throw new EmportException(content, "正则表达式校验未通过:[{}]", content.getContent());
        }
        return true;
    }
}
