package com.tbyf.his.emport.core.validator;

import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportException;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 区间规则校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_SECTION)
public class SectionValidator implements RuleValidator {
    @Override
    public boolean validate(RuleContent content) {
        final String[] split = content.getContent().split(EmportConstants.SEPARATOR);
        final BigDecimal a = new BigDecimal(split[0]);
        final BigDecimal b = new BigDecimal(split[1]);
        try {
            final BigDecimal x = new BigDecimal(content.getValue());
            if (x.compareTo(a) >= 0 && b.compareTo(x) >= 0) {
                return true;
            }
        } catch (NumberFormatException e) {
            throw new EmportException(content, "数据类型异常:{}", content.getValue());
        }
        throw new EmportException(content, "区间校验未通过:[{}]", content.getContent());
    }
}
