package com.tbyf.his.emport.core.validator;

import com.tbyf.his.emport.constant.EmportConstants;
import com.tbyf.his.emport.core.EmportConfig;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import com.tbyf.his.emport.service.ExcelRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 组合规则逻辑与校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(EmportConstants.SERVICE_PREFIX + EmportConstants.VALIDATION_MODE_WITH)
public class WithValidator implements RuleValidator {

    @Autowired
    private ExcelRuleService excelRuleService;

    @Override
    public boolean validate(RuleContent content) {
        final String[] split = content.getContent().split(EmportConstants.SEPARATOR);
        RuleContent rule1 = excelRuleService.getRuleContent(split[0]);
        RuleContent rule2 = excelRuleService.getRuleContent(split[1]);
        rule1.setValue(content.getValue());
        rule2.setValue(content.getValue());
        final RuleValidator validator1 = EmportConfig.getValidator(rule1.getMode());
        if (validator1.validate(rule1)) {
            final RuleValidator validator2 = EmportConfig.getValidator(rule2.getMode());
            return validator2.validate(rule2);
        }
        return false;
    }
}
