package com.tbyf.his.emport.domain.param;

import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "新增excel模板字段", description = "新增excel模板字段")
public class AddExcelTemplateFieldParam extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "templateId不能为空")
    @ApiModelProperty(value = "模板ID")
    private Long templateId;

    @NotBlank(message = "templateFieldName不能为空")
    @ApiModelProperty(value = "模板代码名称(提供垂直模板使用)")
    private String templateFieldName;

    @ApiModelProperty(value = "数据库字段名")
    private String tableFieldName;

    @ApiModelProperty(value = "数据类型,根据数据库类型与手动选择类型判断,例如String,Number,Date(YYYY-MM-DD)")
    private String dataType;

    @ApiModelProperty(value = "排序字段,默认为0")
    private Long sort = 0L;

    @ApiModelProperty(value = "字段说明,例如:登记注册类型代码")
    private String fieldTitle;

    @ApiModelProperty(value = "计量单位说明")
    private String unitTitle;

    @ApiModelProperty(value = "字段位置,直接写横纵坐标或者单元格属性 2,3 或者B3")
    private String fieldAddress;

    @ApiModelProperty(value = "字段单元格合并操作,写明横纵合并大小,默认不合并就是 1,1")
    private String fieldLocation;

}
