package com.tbyf.his.emport.domain.param;

import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "绑定绑定规则参数", description = "绑定绑定规则参数")
public class BindRulesParam extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段ID")
    @NotNull(message = "id不能为空")
    private Long fieldId;

    @ApiModelProperty(value = "规则ID集合")
    private List<Long> ruleIdList;

}
