package com.tbyf.his.emport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "规则测试参数", description = "规则测试参数")
public class TestRuleParam implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "规则类型 1-基础规则 2-组合规则")
    @NotBlank(message = "ruleType不能为空")
    private String ruleType;

    @ApiModelProperty(value = "规则验证模式 基础规则有:正则,判空,大小,插件 组合规则有 || &&")
    @NotBlank(message = "ruleMode不能为空")
    private String ruleMode;

    @ApiModelProperty(value = "规则验证内容 基础规则有: 正则表达式 大于小于的值,插件ID 组合规则就是规则ID的集合")
    @NotBlank(message = "ruleContent不能为空")
    private String ruleContent;

    @ApiModelProperty(value = "用于测试的值")
    @NotBlank(message = "value不能为空")
    private String value;

}
