package com.tbyf.his.emport.domain.param;

import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "更新基础规则", description = "更新基础规则")
public class UpdateExcelRuleParam extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    @ApiModelProperty(value = "规则类型 1-基础规则 2-组合规则")
    private String ruleType;

    @ApiModelProperty(value = "规则验证模式 基础规则有:正则,判空,大小,插件 组合规则有 || &&")
    private String ruleMode;

    @ApiModelProperty(value = "规则验证内容 基础规则有: 正则表达式 大于小于的值,插件ID 组合规则就是规则ID的集合")
    private String ruleContent;

}
