package com.tbyf.his.emport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "Excel导入", description = "Excel导入")
public class UploadExcelParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "上传类型")
    private String type;

    @ApiModelProperty(value = "上传类型")
    @NotBlank(message = "templateId不能为空")
    private String templateId;

    @ApiModelProperty(value = "excel")
    @NotNull(message = "file不能为空")
    private MultipartFile file;

}
