package com.tbyf.his.emport.domain.vo;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.emport.core.RuleContent;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lzz
 * @date 2023/1/30 11:49
 */

@Data
public class FieldInfoVO {

    @ApiModelProperty(value = "字段ID")
    private Long id;

    @ApiModelProperty(value = "代码,提供给树形文档使用")
    private String fieldName;

    @ApiModelProperty(value = "表字段名称")
    private String dataFieldName;

    @ApiModelProperty(value = "数据类型,根据数据库类型与手动选择类型判断,例如String,Number,Date(YYYY-MM-DD)")
    private String dataType;

    @ApiModelProperty(value = "字段位置,直接写横纵坐标或者单元格属性 2,3 或者B3")
    private String fieldAddress;

    @ApiModelProperty(value = "字段单元格合并操作,写明横纵合并大小,默认不合并就是 1,1")
    private String fieldLocation;

    @ApiModelProperty(value = "排序字段")
    private Long sort;

    @ApiModelProperty(value = "指标标题 一、机构属性代码")
    private String fieldTitle;

    @ApiModelProperty(value = "计量单位说明 -")
    private String unitTitle;

    @ApiModelProperty(value = "绑定的规则列表")
    private List<RuleInfoVo> ruleList;

    /**
     * 初始化单元格合并
     */
    public void initFieldLocation() {
        if (StringUtils.isBlank(fieldLocation)) {
            fieldAddress = "1,1";
        }
    }

    /* ===========功能字段========= */

    /**
     * 纵坐标
     */
    private Integer horizontal;

    private List<RuleContent> ruleContentList;

    public void initContentList() {
        if (CollectionUtils.isEmpty(ruleContentList)) {
            if (!CollectionUtils.isEmpty(ruleList)) {
                ruleContentList = new ArrayList<>();
                ruleList.forEach(rule -> {
                    RuleContent content = new RuleContent();
                    content.setId(String.valueOf(rule.getId()));
                    content.setType(rule.getType());
                    content.setMode(rule.getMode());
                    content.setContent(rule.getContent());
                    content.setName(rule.getName());
                    ruleContentList.add(content);
                });
            }
        }
    }


}
