drop table if exists EXCEL_TEMPLATE;
create table EXCEL_TEMPLATE
(
    ID              bigint auto_increment comment '主键ID' primary key,
    TEMPLATE_NAME   varchar(256) null comment '模板名称',
    SHEET_NAME      varchar(256) null comment '模板标题/sheet名称',
    TEMPLATE_TYPE   varchar(4) null comment '模板类型 1-横向普通模板 2-单文档垂直模板',
    DATASOURCE_ID   varchar(256) null comment '数据源ID',
    TABLE_PART_NAME varchar(256) null comment '表名称',
    CREATE_BY       varchar(64) null comment '创建人',
    CREATE_TIME     timestamp null comment '创建时间',
    UPDATE_BY       varchar(64) null comment '更新人',
    UPDATE_TIME     timestamp null comment '更新时间',
    REMARK          text null comment '备注'
) comment 'Excel模板表';

drop table if exists EXCEL_TEMPLATE_FIELD;
create table EXCEL_TEMPLATE_FIELD
(
    ID                  bigint auto_increment comment '主键ID' primary key,
    TEMPLATE_ID         bigint null comment '模板ID',
    TEMPLATE_FIELD_NAME varchar(64) null comment '模板代码名称(提供垂直模板使用)',
    TABLE_FIELD_NAME    varchar(64) null comment '数据库字段名',
    DATA_TYPE           varchar(64) null comment '数据类型,根据数据库类型与手动选择类型判断,例如String,Number,Date(YYYY-MM-DD)',
    SORT                bigint null comment '排序字段',
    FIELD_TITLE         varchar(64) null comment '字段说明  登记注册类型代码:',
    FIELD_ADDRESS       varchar(64) null comment '字段位置,直接写横纵坐标或者单元格属性 2,3 或者B3',
    FIELD_LOCATION      varchar(64) null comment '字段单元格合并操作,写明横纵合并大小,默认不合并就是 1,1',
    UNIT_TITLE          varchar(64) null comment '单位说明 人/人次',
    CREATE_BY           varchar(64) null comment '创建人',
    CREATE_TIME         timestamp null comment '创建时间',
    UPDATE_BY           varchar(64) null comment '更新人',
    UPDATE_TIME         timestamp null comment '更新时间',
    REMARK              text null comment '备注'
) comment 'Excel模板字段表';

drop table if exists EXCEL_RULE;
create table EXCEL_RULE
(
    ID           bigint auto_increment comment '主键ID' primary key,
    RULE_NAME    varchar(64) null comment '规则名称',
    RULE_TYPE    varchar(64) null comment '规则类型 1-基础规则 2-组合规则',
    RULE_MODE    varchar(64) null comment '规则验证模式',
    RULE_CONTENT varchar(256) null comment '规则验证内容',
    CREATE_BY    varchar(64) null comment '创建人',
    CREATE_TIME  timestamp null comment '创建时间',
    UPDATE_BY    varchar(64) null comment '更新人',
    UPDATE_TIME  timestamp null comment '更新时间',
    REMARK       text null comment '备注'
) comment 'Excel基础规则与组合规则表';

drop table if exists EXCEL_FIELD_RULE;
create table EXCEL_FIELD_RULE
(
    FIELD_ID bigint null comment '字段ID',
    RULE_ID  bigint null comment '规则ID'
) comment 'Excel模板字段规则对应表';