package com.tbyf.his.emport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "EXCEL_RULE", autoResultMap = true)
@ApiModel(value = "Excel基础规则与组合规则表", description = "Excel基础规则与组合规则表")
public class ExcelRule extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "规则名称")
    @TableField("RULE_NAME")
    private String ruleName;

    @ApiModelProperty(value = "规则类型 1-基础规则 2-组合规则")
    @TableField("RULE_TYPE")
    private String ruleType;

    @ApiModelProperty(value = "规则验证模式 基础规则有:正则,判空,大小,插件 组合规则有 || &&")
    @TableField("RULE_MODE")
    private String ruleMode;

    @ApiModelProperty(value = "规则验证内容 基础规则有: 正则表达式 大于小于的值,插件ID 组合规则就是规则ID的集合")
    @TableField("RULE_CONTENT")
    private String ruleContent;
}
