package com.tbyf.his.emport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "EXCEL_TEMPLATE", autoResultMap = true)
@ApiModel(value = "excel模板表", description = "excel模板")
public class ExcelTemplate extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "模板名称")
    @TableField("TEMPLATE_NAME")
    @NotBlank(message = "模板名称不能为空")
    private String templateName;

    @ApiModelProperty(value = "模板标题/sheet名称")
    @TableField("SHEET_NAME")
    private String sheetName;

    @ApiModelProperty(value = "模板类型 1-横向普通模板 2-单文档垂直模板")
    @TableField("TEMPLATE_TYPE")
    private String templateType;

    @ApiModelProperty(value = "数据源ID")
    @TableField("DATASOURCE_ID")
    private String dataSourceId;

    @ApiModelProperty(value = "表名称")
    @TableField("TABLE_PART_NAME")
    private String tablePartName;

}
