package com.tbyf.his.emport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tbyf.his.emport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "EXCEL_TEMPLATE_FIELD", autoResultMap = true)
@ApiModel(value = "excel模板字段表", description = "excel模板字段表")
public class ExcelTemplateField extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "模板ID")
    @TableField("TEMPLATE_ID")
    private Long templateId;

    @ApiModelProperty(value = "模板代码名称(提供垂直模板使用)")
    @TableField("TEMPLATE_FIELD_NAME")
    private String templateFieldName;

    @ApiModelProperty(value = "数据库字段名")
    @TableField("TABLE_FIELD_NAME")
    private String tableFieldName;

    @ApiModelProperty(value = "数据类型,根据数据库类型与手动选择类型判断,例如String,Number,Date(YYYY-MM-DD)")
    @TableField("DATA_TYPE")
    private String dataType;

    @ApiModelProperty(value = "排序字段")
    @TableField("SORT")
    private Long sort;

    @ApiModelProperty(value = "字段说明,例如:登记注册类型代码")
    @TableField("FIELD_TITLE")
    private String fieldTitle;

    @ApiModelProperty(value = "字段位置,直接写横纵坐标或者单元格属性 2,3 或者B3")
    @TableField("FIELD_ADDRESS")
    private String fieldAddress;

    @ApiModelProperty(value = "字段单元格合并操作,写明横纵合并大小,默认不合并就是 1,1")
    @TableField("FIELD_LOCATION")
    private String fieldLocation;

    @ApiModelProperty(value = "计量单位说明")
    @TableField("UNIT_TITLE")
    private String unitTitle;

}
