package com.tbyf.his.emport.service;

import com.tbyf.his.emport.domain.vo.FieldInfoVO;
import com.tbyf.his.emport.entity.ExcelTemplate;
import com.tbyf.his.emport.entity.ExcelTemplateField;
import org.apache.poi.ss.usermodel.Workbook;

import java.util.List;

/**
 * @author lzz
 * @date 2023/2/3 9:33
 */

public interface EmportService {

    /**
     * 动态导入普通文档
     *
     * @param template
     * @param list
     * @param workbook
     */
    void dynamicImportBySimple(ExcelTemplate template, List<FieldInfoVO> list, Workbook workbook);

    /**
     * 动态导入竖形单文档
     *
     * @param template
     * @param list
     * @param workbook
     */
    void dynamicImportByVertical(ExcelTemplate template, List<FieldInfoVO> list, Workbook workbook);

    /**
     * 初始化普通模板
     *
     * @param template
     * @param workbook
     * @return
     */
    List<ExcelTemplateField> initTemplateBySimple(ExcelTemplate template, Workbook workbook);

    /**
     * 初始化竖形单文档模板
     *
     * @param template
     * @param workbook
     * @return
     */
    List<ExcelTemplateField> initTemplateByVertical(ExcelTemplate template, Workbook workbook);

}
