package com.tbyf.his.emport.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.domain.param.AddExcelRuleParam;
import com.tbyf.his.emport.domain.param.QueryExcelRuleParam;
import com.tbyf.his.emport.domain.param.TestRuleParam;
import com.tbyf.his.emport.domain.param.UpdateExcelRuleParam;
import com.tbyf.his.emport.entity.ExcelRule;

import java.util.List;

/**
 * @author lzz
 * @date 2023/1/10 15:53
 */

public interface ExcelRuleService extends IService<ExcelRule> {

    /**
     * 分页查询规则信息
     *
     * @param param
     * @return
     */
    TableDataInfo queryRule(QueryExcelRuleParam param);

    /**
     * 删除规则
     *
     * @param ruleId
     * @return
     */
    boolean deleteRule(Long ruleId);

    /**
     * 新增基础规则配置
     *
     * @param param
     * @return
     */
    boolean addRule(AddExcelRuleParam param);

    /**
     * 修改规则配置
     *
     * @param param
     * @return
     */
    boolean updateRule(UpdateExcelRuleParam param);

    /**
     * 查询规则字典
     *
     * @return
     */
    List<ExcelRule> queryRuleDict();

    /**
     * 测试规则
     *
     * @param param
     * @return
     */
    AjaxResult testRule(TestRuleParam param);

    /**
     * 获取包装后的RoleContent
     *
     * @param id
     * @return
     */
    RuleContent getRuleContent(String id);

    /**
     * 查询规则名称集合
     *
     * @param ids
     * @return
     */
    List<String> getRuleNames(String ids);
}
