package com.tbyf.his.emport.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.emport.domain.param.AddExcelTemplateFieldParam;
import com.tbyf.his.emport.domain.param.QueryTemplateFieldParam;
import com.tbyf.his.emport.domain.param.UpdateExcelTemplateFieldParam;
import com.tbyf.his.emport.entity.ExcelTemplateField;

/**
 * @author lzz
 * @date 2023/1/10 15:53
 */

public interface ExcelTemplateFieldService extends IService<ExcelTemplateField> {

    /**
     * 添加
     *
     * @param param
     * @return
     */
    boolean addTemplateField(AddExcelTemplateFieldParam param);

    /**
     * 更新
     *
     * @param param
     * @return
     */
    boolean updateTemplateField(UpdateExcelTemplateFieldParam param);

    /**
     * 分页查询字段
     *
     * @param param
     * @return
     */
    TableDataInfo queryTemplateField(QueryTemplateFieldParam param);

    /**
     * 删除模板字段
     *
     * @param templateFieldId
     * @return
     */
    boolean deleteTemplateField(Long templateFieldId);

    /**
     * 字段规则测试
     *
     * @param fieldId
     * @param value
     * @return
     */
    AjaxResult fieldRuleTest(String fieldId, String value);
}
