package com.tbyf.his.emport.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.emport.domain.param.QueryTemplateParam;
import com.tbyf.his.emport.domain.param.UploadExcelParam;
import com.tbyf.his.emport.entity.ExcelTemplate;
import com.tbyf.his.emport.entity.ExcelTemplateField;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author lzz
 * @date 2023/1/10 15:53
 */

public interface ExcelTemplateService extends IService<ExcelTemplate> {

    /**
     * 新增excel模板
     *
     * @param template
     * @return
     */
    boolean addTemplate(ExcelTemplate template);

    /**
     * 修改excel模板
     *
     * @param template
     * @return
     */
    boolean updateTemplate(ExcelTemplate template);

    /**
     * 分页查询模板
     *
     * @param param
     * @return
     */
    TableDataInfo queryTemplate(QueryTemplateParam param);

    /**
     * 删除模板
     * 连带删除字段信息,以及字段信息所有的规则绑定信息
     *
     * @param templateId
     * @return
     */
    boolean deleteTemplate(Long templateId);

    /**
     * 导入excel
     *
     * @param param
     * @return
     */
    boolean importExcel(UploadExcelParam param);

    /**
     * 模板初始化
     *
     * @param param
     */
    void initTemplate(UploadExcelParam param);

    /**
     * 模板初始化更新字段  (事务)
     *
     * @param templateId
     * @param list
     */
    void initTemplateField(Long templateId, List<ExcelTemplateField> list);

    /**
     * 模板下载
     *
     * @param templateId
     * @param response
     */
    void downloadTemplate(Long templateId, HttpServletResponse response);
}
