package com.tbyf.his.emport.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.emport.domain.param.BindRulesParam;
import com.tbyf.his.emport.entity.ExcelFieldRule;
import com.tbyf.his.emport.entity.ExcelRule;
import com.tbyf.his.emport.mapper.ExcelFieldRuleMapper;
import com.tbyf.his.emport.service.ExcelFieldRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/1/10 15:53
 */

@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class ExcelFieldRuleServiceImpl extends ServiceImpl<ExcelFieldRuleMapper, ExcelFieldRule> implements ExcelFieldRuleService {

    @Autowired
    private ExcelFieldRuleMapper excelFieldRuleMapper;

    @Autowired
    @Lazy
    private ExcelFieldRuleService excelFieldRuleService;

    @Override
    public boolean bindRules(BindRulesParam param) {
        final boolean remove = excelFieldRuleService.remove(Wrappers.lambdaQuery(ExcelFieldRule.class).eq(ExcelFieldRule::getFieldId, param.getFieldId()));
        if (!CollectionUtils.isEmpty(param.getRuleIdList())) {
            final List<ExcelFieldRule> fieldRules = param.getRuleIdList().stream()
                    .map(item -> {
                        final ExcelFieldRule fieldRule = new ExcelFieldRule();
                        fieldRule.setFieldId(param.getFieldId())
                                .setRuleId(item);
                        return fieldRule;
                    }).collect(Collectors.toList());
            excelFieldRuleService.saveBatch(fieldRules);
        }
        return true;
    }

    @Override
    public List<ExcelRule> listFieldRule(String fieldId) {
        return excelFieldRuleMapper.listFieldRule(fieldId);
    }
}
