package com.tbyf.his.emport.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.exception.base.BaseException;
import com.tbyf.his.emport.core.EmportConfig;
import com.tbyf.his.emport.core.RuleContent;
import com.tbyf.his.emport.core.RuleValidator;
import com.tbyf.his.emport.domain.param.AddExcelTemplateFieldParam;
import com.tbyf.his.emport.domain.param.QueryTemplateFieldParam;
import com.tbyf.his.emport.domain.param.UpdateExcelTemplateFieldParam;
import com.tbyf.his.emport.entity.ExcelFieldRule;
import com.tbyf.his.emport.entity.ExcelTemplateField;
import com.tbyf.his.emport.mapper.ExcelTemplateFieldMapper;
import com.tbyf.his.emport.service.ExcelFieldRuleService;
import com.tbyf.his.emport.service.ExcelRuleService;
import com.tbyf.his.emport.service.ExcelTemplateFieldService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author lzz
 * @date 2023/1/10 15:53
 */

@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class ExcelTemplateFieldServiceImpl extends ServiceImpl<ExcelTemplateFieldMapper, ExcelTemplateField> implements ExcelTemplateFieldService {

    @Autowired
    private ExcelTemplateFieldMapper excelTemplateFieldMapper;

    @Autowired
    private ExcelFieldRuleService excelFieldRuleService;

    @Autowired
    private ExcelRuleService excelRuleService;

    @Autowired
    @Lazy
    private ExcelTemplateFieldService excelTemplateFieldService;

    @Override
    public boolean addTemplateField(AddExcelTemplateFieldParam param) {
        // 表字段不能重复
        final LambdaQueryWrapper<ExcelTemplateField> queryWrapper = Wrappers.lambdaQuery(ExcelTemplateField.class);
        queryWrapper.eq(ExcelTemplateField::getTemplateId, param.getTemplateId())
                .eq(ExcelTemplateField::getTableFieldName, param.getTableFieldName());
        final long count = excelTemplateFieldService.count(queryWrapper);
        if (count > 0) {
            throw new BaseException("表字段名已经被使用");
        }
        ExcelTemplateField field = new ExcelTemplateField();
        BeanUtils.copyProperties(param, field);
        field.initAdd();
        return excelTemplateFieldService.save(field);
    }

    @Override
    public boolean updateTemplateField(UpdateExcelTemplateFieldParam param) {
        // 表字段不能重复
        final LambdaQueryWrapper<ExcelTemplateField> queryWrapper = Wrappers.lambdaQuery(ExcelTemplateField.class);
        queryWrapper.eq(ExcelTemplateField::getTemplateId, param.getTemplateId())
                .eq(ExcelTemplateField::getTableFieldName, param.getTableFieldName())
                .ne(ExcelTemplateField::getId, param.getId());
        final long count = excelTemplateFieldService.count(queryWrapper);
        if (count > 0) {
            throw new BaseException("表字段名已经被使用");
        }
        ExcelTemplateField field = new ExcelTemplateField();
        BeanUtils.copyProperties(param, field);
        field.initUpdate();
        return excelTemplateFieldService.updateById(field);
    }

    @Override
    public TableDataInfo queryTemplateField(QueryTemplateFieldParam param) {
        final Page<ExcelTemplateField> page = Page.of(param.getPageNum(), param.getPageSize());
        final LambdaQueryWrapper<ExcelTemplateField> queryWrapper = Wrappers.lambdaQuery(ExcelTemplateField.class);
        queryWrapper.eq(ExcelTemplateField::getTemplateId, param.getTemplateId());
        if (StringUtils.hasText(param.getKeyword())) {
            queryWrapper.and(wrapper -> {
                wrapper.like(ExcelTemplateField::getTemplateFieldName, param.getKeyword())
                        .or()
                        .like(ExcelTemplateField::getTableFieldName, param.getKeyword())
                        .or()
                        .like(ExcelTemplateField::getFieldTitle, param.getKeyword());
            });
        }
        queryWrapper.orderByAsc(ExcelTemplateField::getSort);
        final Page<ExcelTemplateField> templatePage = excelTemplateFieldService.page(page, queryWrapper);
        return param.convert(templatePage);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteTemplateField(Long templateFieldId) {
        // 先删除关联规则,再删除本类数据
        final LambdaQueryWrapper<ExcelFieldRule> wrapper1 = Wrappers.lambdaQuery(ExcelFieldRule.class);
        wrapper1.eq(ExcelFieldRule::getFieldId, templateFieldId);
        excelFieldRuleService.remove(wrapper1);
        return excelTemplateFieldService.removeById(templateFieldId);
    }

    @Override
    public AjaxResult fieldRuleTest(String fieldId, String value) {
        final List<ExcelFieldRule> list = excelFieldRuleService.list(Wrappers.lambdaQuery(ExcelFieldRule.class)
                .eq(ExcelFieldRule::getFieldId, fieldId));
        list.forEach(obj -> {
            final RuleContent ruleContent = excelRuleService.getRuleContent(String.valueOf(obj.getRuleId()));
            ruleContent.setValue(value);
            final RuleValidator validator = EmportConfig.getValidator(ruleContent.getMode());
            if (Objects.isNull(validator)) {
                throw new BaseException("校验服务加载异常,请联系管理员");
            }
            validator.validate(ruleContent);
        });
        return AjaxResult.success();
    }
}
