package com.tbyf.his.job.mapper;

import com.tbyf.his.job.domain.SysJobNew;

import java.util.List;

/**
 * 调度任务信息 数据层
 *
 * @author guopx
 */
public interface SysJobNewMapper {
    /**
     * 查询调度任务日志集合
     *
     * @param job 调度信息
     * @return 操作日志集合
     */
    public List<SysJobNew> selectSysJobNewList(SysJobNew job);

    /**
     * 查询所有调度任务
     *
     * @return 调度任务列表
     */
    public List<SysJobNew> selectSysJobNewAll();

    /**
     * 通过调度ID查询调度任务信息
     *
     * @param jobId 调度ID
     * @return 角色对象信息
     */
    public SysJobNew selectSysJobNewByJobId(Long jobId);

    /**
     * 通过调度ID删除调度任务信息
     *
     * @param jobId 调度ID
     * @return 结果
     */
    public int deleteSysJobNewByJobId(Long jobId);

    /**
     * 批量删除调度任务信息
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteSysJobNewByJobIds(Long[] ids);

    /**
     * 修改调度任务信息
     *
     * @param job 调度任务信息
     * @return 结果
     */
    public int updateSysJobNew(SysJobNew job);

    /**
     * 新增调度任务信息
     *
     * @param job 调度任务信息
     * @return 结果
     */
    public int insertSysJobNew(SysJobNew job);
}
