package com.tbyf.his.job.obj;

import com.tbyf.his.common.exception.ServiceException;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 定时任务执行器工厂
 *
 * @author: fr
 * @date: 2022年07月25日 14:32
 */
public class JobExecuteFactory {

    protected static Map<Integer, JobExecute> JOB_CACHE = new ConcurrentHashMap<>(4);

    /**
     * 注册
     *
     * @param jobEnum
     * @param execute
     */
    protected static void register(JobEnum jobEnum, JobExecute execute) {
        JOB_CACHE.put(jobEnum.type, execute);
    }

    /**
     * 移除
     *
     * @param jobEnum
     * @param execute
     */
    protected static void remove(JobEnum jobEnum, JobExecute execute) {
        JOB_CACHE.remove(jobEnum.type, execute);
        if (JOB_CACHE.isEmpty()) {
            JOB_CACHE = null;
        }
    }

    public static JobExecute getJobExecute(JobEnum jobEnum) {
        return Optional.of(JOB_CACHE.get(jobEnum.type))
                .orElseThrow(() -> new ServiceException("未知类型的执行器"));
    }

}
