package com.tbyf.his.job.obj;

import com.tbyf.his.common.utils.spring.SpringUtils;
import com.tbyf.his.job.domain.SysJobNew;
import com.tbyf.his.job.util.JobInvokeUtil;
import com.tbyf.his.system.service.ISysPluginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Service;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * @author: fr
 * @date: 2022年07月25日 14:53
 */
@Service
public class JobExecuteJar implements JobExecute, InitializingBean, DisposableBean {

    private static final Logger logger = LoggerFactory.getLogger(JobExecuteJar.class);

    /**
     * 分隔符，区分类路径和目标类方法
     */
    private static final String SYMBOL = "=";

    @Autowired
    private ISysPluginService pluginService;


    @Override
    public void execute(SysJobNew job) throws Exception {
        logger.info("[定时任务]执行jar:{}", job);
//        String[] split = job.getInvokeTarget().split(SYMBOL);
//        if (split.length != 2) { throw new ServiceException("目标字符串格式不规范"); }
//        String classPath = split[0].trim();
//        String target = split[1].trim();
        String classPath = JobInvokeUtil.getBeanName(job.getInvokeTarget());
        String target = job.getInvokeTarget();
        // 获取jar，并加载到spring容器中
        File file = pluginService.getLocalFile(job.getLinkTableId());
        registerBean(file.getAbsolutePath(), classPath, target);
        // 执行目标类方法
        JobInvokeUtil.invokeJarMethod(job);
        logger.info("[定时任务]执行jar结果:{}", "成功");
    }

    /**
     * 判断bean是否存在
     *
     * @param beanName
     * @return
     */
    private boolean beanIsExist(String beanName) {
        boolean isExist;
        try {
            Object bean = SpringUtils.getApplicationContext().getBean(beanName);
            isExist = null != bean;
        } catch (BeansException e) {
            isExist = false;
        }
        return isExist;
    }

    private void registerBean(String filePath, String classPath, String target) throws Exception {
        String beanName = JobInvokeUtil.getJarBeanName(target);
        if (beanIsExist(beanName)) {
            logger.warn("[定时任务]执行jar:{}已经存在", beanName);
            return;
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL("file:" + filePath)});
        Class<?> cls = classLoader.loadClass(classPath);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(cls);
        BeanDefinition beanDefinition = builder.getBeanDefinition();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory) SpringUtils.getApplicationContext().getAutowireCapableBeanFactory();
        beanFactory.registerBeanDefinition(beanName, beanDefinition);
        Object bean = SpringUtils.getApplicationContext().getBean(beanName);
        logger.info("bean注册:{} 成功注入 {}  ", beanName, bean);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册进入工厂
        JobExecuteFactory.register(JobEnum.EXECUTE_JAR, this);
    }

    @Override
    public void destroy() throws Exception {
        JobExecuteFactory.remove(JobEnum.EXECUTE_JAR, this);
    }
}
