package com.tbyf.his.patient360.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseInfoModel;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.mapper.FieldMappingMapper;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.core.text.Convert;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.sign.Base64;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.framework.datasource.DynamicDataSourceContextHolder;
import com.tbyf.his.framework.system.domain.SysOperLog;
import com.tbyf.his.framework.system.service.impl.SysConfigServiceImpl;
import com.tbyf.his.framework.system.util.DictUtils;
import com.tbyf.his.patient360.domain.Patient360CountInfo;
import com.tbyf.his.patient360.domain.Patient360Info;
import com.tbyf.his.patient360.domain.Patient360MenuInfo;
import com.tbyf.his.patient360.mapper.Patient360Mapper;
import com.tbyf.his.patient360.service.Patient360Service;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import com.tbyf.his.system.service.ISysDatasourceService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;
import org.springframework.util.FastByteArrayOutputStream;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class Patient360ServiceImpl implements Patient360Service {
    @Autowired
    Patient360Mapper patient360Mapper;
    @Autowired
    SysConfigServiceImpl sysConfigService;
    @Autowired
    IApiconvertBaseinfoService apiconvertBaseinfoService;
    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;
    @Autowired
    private FieldMappingMapper fieldMapper;
    @Autowired
    private ISysDatasourceService sysDatasourceService;

    @Override
    public List<SysOperLog> queryPatient360Info(Patient360Info patient360Info) {
        String api360 = sysConfigService.selectConfigByKey("api360");
        String[] split = api360.split(",");
        String sql = "and ( ";
        for (int i = 0; i < split.length; i++) {
            if (i == 0) {
                sql = sql + "oper_param like '%\"apiId\":" + split[i] + "%' ";
            } else if (i + 1 == split.length) {
                sql = sql + " or oper_param like '%\"apiId\":" + split[i] + "%' ) ";
            } else {
                sql = sql + " or oper_param like '%\"apiId\":" + split[i] + "%' ";
            }
        }
        patient360Info.setSql(sql);
        return patient360Mapper.selectPatient360Info(patient360Info);
    }

    @Override
    public Map<String, List<Patient360CountInfo>> queryPatient360Count(Patient360Info patient360Info) {

        Map<String, List<Patient360CountInfo>> objects = new HashMap();
        String api360 = sysConfigService.selectConfigByKey("api360");

        String[] split = api360.split(",");

        for (int i = 0; i < split.length; i++) {
            patient360Info.setApiId(split[i]);
            List<Patient360CountInfo> patient360CountInfos = new ArrayList<>();
            if (patient360Info.getModelFlag().equals("1")) {
                PageHelper.clearPage();
                patient360CountInfos = patient360Mapper.selectPatient360Count(patient360Info);
            } else {
                PageHelper.clearPage();
                patient360CountInfos = patient360Mapper.selectPatient360CountByTime(patient360Info);
            }

            objects.put(split[i], patient360CountInfos);
        }

        return objects;
    }

    @Override
    public List<Patient360MenuInfo> queryPatient360Menu(Patient360MenuInfo patient360MenuInfo) {
        List<Patient360MenuInfo> patient360MenuInfos = patient360Mapper.queryPatient360Menu(patient360MenuInfo);
        return patient360MenuInfos;
    }

    @Override
    public int addPatient360Manu(Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Mapper.addPatient360Manu(patient360MenuInfo);
        return i;
    }

    @Override
    public int updatePatient360Manu(Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Mapper.updatePatient360Manu(patient360MenuInfo);
        return i;
    }

    @Override
    public int delPatient360Menu(Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Mapper.delPatient360Menu(patient360MenuInfo);
        return i;
    }

    @Override
    public List<Patient360MenuInfo> queryPatient360MenuList(Patient360MenuInfo patient360MenuInfo) {
        return patient360Mapper.queryPatient360MenuList(patient360MenuInfo);
    }

    private void switchDsByDsId(Long dsId) {
        SysDatasource ds = selectSysDatasourceByDatasourceId(dsId);
        if (StringUtils.isNotNull(ds)) {

            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//            DataSourceUtil.switchDs(ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

    }

    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId) {
        DataSourceUtil.switchDefaultDs();
        return sysDatasourceMapper.selectSysDatasourceByDatasourceId(datasourceId);
    }

    //日期前后天数的新日期
    private static String getDayBefore(String specifiedDay, int x) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            if (specifiedDay.indexOf("-") > 0) {
                date = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
            } else {
                date = new SimpleDateFormat("yy/MM/dd").parse(specifiedDay);
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(Calendar.DATE);
        //c.set(Calendar.DATE, day - x);    //往前推几天
        c.set(Calendar.DATE, day + x);  //往后推几天

        String dayBefore;
        if (specifiedDay.indexOf("-") > 0) {
            dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        } else {
            dayBefore = new SimpleDateFormat("yyyy/MM/dd").format(c.getTime());
        }

        return dayBefore;

    }

    public List<Map<String, Object>> selectList(String sqlStr, Map<String, Object> param) {
        sqlStr = sqlStr.replace("#{", "#{param.");
        return patient360Mapper.selectList(sqlStr, param);
    }

    //返回日期
    public Date parseDate(Object str) {
        if (str == null) {
            return null;
        } else {
            try {
                String[] parsePatterns = new String[]{"yyyy年MM月dd日", "yyyy年MM月dd日 HH时", "yyyy年MM月dd日 HH时mm分", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
                return DateUtils.parseDate(str.toString(), parsePatterns);
            } catch (ParseException var2) {
                return null;
            }
        }

    }

    //获取竖向时间text
    private static String getVerticalText(String data) {
        String text = "";
        String temp = "";

        temp = data.substring(11, 13);
        String list[] = new String[]{"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
        if (temp.substring(0, 1).equals("0") && temp.substring(1, 2).equals("0")) { //00
            text = "零时";
        } else if (temp.substring(0, 1).equals("0") && !temp.substring(1, 2).equals("0")) { //N!0
            text = list[Convert.toInt(temp.substring(1, 2), 0)] + "时";
        } else if (temp.substring(0, 1).equals("1")) { //1N
            if (temp.substring(1, 2).equals("0")) {
                text = "十时";
            } else {
                text = "十" + list[Convert.toInt(temp.substring(1, 2), 0)] + "时";
            }

        } else if (temp.substring(1, 2).equals("0")) { //N0
            text = list[Convert.toInt(temp.substring(0, 1), 0)] + "十" + "时";

        } else {
            text = list[Convert.toInt(temp.substring(0, 1), 0)] + "十" + list[Convert.toInt(temp.substring(1, 2), 0)] + "时";
        }

        temp = data.substring(14, 16);
        if (temp.substring(0, 1).equals("0") && temp.substring(1, 2).equals("0")) {
            text += "零分";
        } else if (temp.substring(0, 1).equals("0") && !temp.substring(1, 2).equals("0")) {
            text += list[Convert.toInt(temp.substring(1, 2), 0)] + "分";
        } else if (temp.substring(1, 2).equals("0")) { //N0
            text += list[Convert.toInt(temp.substring(0, 1), 0)] + "十" + "分";

        } else {
            text += list[Convert.toInt(temp.substring(0, 1), 0)] + "十" + list[Convert.toInt(temp.substring(1, 2), 0)] + "分";
        }


        return text;
    }

    //删除重复点
    private static int deleteRepeatData(List<Map<String, Object>> tempList, Map<String, Object> lastTemperatureTemp, int latticeNum, int timeLen) {
        //int timeLen = Convert.toInt( item.get("time"),0);
        int latticeNumTemp = 0;

        if (timeLen == 0) {
            latticeNumTemp = 1;
        } else {
            latticeNumTemp = (int) Math.ceil((double) timeLen / 4);
        }
        if (latticeNumTemp == latticeNum) {
            //覆盖，删除前一条
            tempList.remove(lastTemperatureTemp);
        }
        return latticeNumTemp;
    }

    //获取apiSQL、执行结果

    public List<Map<String, Object>> getList(Long appId, JSONObject inParamJson) {
        String targetSqlText;
        //根据apiID获取接口信息selectApiconvertBaseinfoByApiId
        ApiconvertBaseinfo apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiId(appId);
        if (apiconvertBaseinfo == null) {
            throw new ServiceException("app配置为空");
        }

        //数据源判断
        if (apiconvertBaseinfo.getTargetDatasource() == null || apiconvertBaseinfo.getTargetDatasource().equals("")) {
            throw new ServiceException("Sql协议数据源不能为空");
        }

        //获取sql
        targetSqlText = apiconvertBaseinfo.getTargetSqltext();


        //sql为空判断
        if (targetSqlText == null || targetSqlText.equals("")) {
            throw new ServiceException("Sql语句不能为空");
        }

        //sql转码
        // targetSqlText = new String(Base64.getDecoder().decode(targetSqlText.getBytes()));
        targetSqlText = Base64.decode(targetSqlText);

        //转json格式


        //先拿到传入的数据，忽略结构和映射

        FieldMapping fieldMapping = new FieldMapping();
        fieldMapping.setApiId(appId);
        fieldMapping.setParamFlag("in");
        fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
        List<FieldMapping> fieldMappings = fieldMapper.selectFieldList(fieldMapping);


        for (FieldMapping mapping : fieldMappings) {
            String fieldName = mapping.getFieldName();
            String pattern1 = "#" + fieldName + "#";

            if (targetSqlText.contains(pattern1)) {
                targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
            }
        }


        //执行sql
        List<Map<String, Object>> result = sysDatasourceService.switchDsAndExecuteSql(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
        return result;
    }

    //创建体温单
    @Override
    public Map<String, Object> createThermometer(Map<String, Object> data) {
        Map<String, Object> refmap = new JSONObject();
        List<Map<String, Object>> tempList = new ArrayList<>();
        Map<String, Object> emrSys = new JSONObject();
        Map<String, Object> map;
        Map<String, Object> mapTemp;
        List<Map<String, Object>> signData = new ArrayList<>();
        String sql = "";
        JSONObject inParamJsonNew = new JSONObject();
        int painScoreNum = 0;//疼痛评估 增加格子数 4
        int babySign = 2; //1 成人  2婴儿,
        int babynum = 1;//

        if (data.get("baby").equals(0) || data.get("baby").equals("0")) {
            babySign = 1;
            babynum = 0;
        } else {
            babySign = 2;
            babynum = Convert.toInt(data.get("baby"), 0);
            painScoreNum = 0;
        }


        //基础参数

        emrSys.put("cellMinTwTemperature", 33.6);//体温最小值
        emrSys.put("cellSplitTemperature", 0.2 / babySign);//体温每格代表值
        emrSys.put("cellMinMb", 12);//脉搏最小值
        emrSys.put("cellSplitMb", 4 / babySign);//脉搏每格代表值
        emrSys.put("cellMinHx", 3);
        emrSys.put("cellSplitHx", 1);
        emrSys.put("painScoreNum", painScoreNum);


        //画布大小
        map = new JSONObject();
        map.put("emptyHeight", "650px");
        map.put("emptyWidth", "800px");
        refmap.put("emrSysEmpty", map);

        //画布格子X
        map = new JSONObject();
        map.put("day", 0);//天数 7天
        map.put("time", 6); //一天多少分段
        refmap.put("xLineLen", map);

        //画布格子Y
        map = new JSONObject();
        map.put("XRegion", 10);// //X轴坐标分几个大块
        map.put("XRegion", new int[]{2, 5, 5, 5, 5, 5, 5, 5, 5, 3}); //一天多少分段


        map.put("XShareAll", (45 + painScoreNum) * babySign); //总格子数
        map.put("XLineArr", new int[]{3 * babySign, 8 * babySign, 13 * babySign, 18 * babySign, 23 * babySign, 28 * babySign, 33 * babySign, 38 * babySign, 43 * babySign}); //需要特殊处理的横线 从上往下算


        refmap.put("yLineLen", map);


        //获取his住院患者基本信息
        //表格数据 head 【基本信息 + 七天日期】
        Long appIdNow = 1805L;
        inParamJsonNew.put("zybah", data.get("zybah"));
        String jsonString = inParamJsonNew.toJSONString();
        ApiconvertBaseInfoModel apiconvertBaseInfoModel = new ApiconvertBaseInfoModel();

        DataSourceUtil.switchDefaultDs();
        //his患者基本信息
        appIdNow = 1805L;
        apiconvertBaseInfoModel.setApiId(appIdNow);
        apiconvertBaseInfoModel.setParam(jsonString);
        Object o = apiconvertBaseinfoService.handlerRequest(apiconvertBaseInfoModel);

        System.out.println(o);
        List<Map<String, Object>> diagnosis = getList(appIdNow, inParamJsonNew);

        //his转科信息
        appIdNow = 1846L;
        apiconvertBaseInfoModel.setApiId(appIdNow);
        List<Map<String, Object>> TransferInfo = getList(appIdNow, inParamJsonNew);

        //婴儿信息

        appIdNow = 1885L;
        apiconvertBaseInfoModel.setApiId(appIdNow);
        inParamJsonNew.put("babynum", babynum);
        jsonString = inParamJsonNew.toJSONString();
        apiconvertBaseInfoModel.setParam(jsonString);
        List<Map<String, Object>> TransferBabyInfo = getList(appIdNow, inParamJsonNew);
        //切换成emr
        switchDsByDsId(Long.parseLong("9"));

        if (StringUtils.isNotEmpty(TransferBabyInfo) && TransferBabyInfo.size() > 0) {

            String yecsny = Convert.toStr(TransferBabyInfo.get(0).get("yecsny"), "");
            if (yecsny.length() > 1) {
                yecsny = yecsny.substring(0, 4) + "年" + yecsny.substring(5, 7) + "月" + yecsny.substring(8, 10) + "日" + yecsny.substring(11, 13) + "时" + yecsny.substring(14, 16) + "分";
                TransferBabyInfo.get(0).put("yecsnyFormat", yecsny);

            } else {
                TransferBabyInfo.get(0).put("yecsnyFormat", "");
            }
            refmap.put("tableDataBaby", TransferBabyInfo.get(0));

        } else {
            refmap.put("tableDataBaby", new JSONObject());
        }

        if (StringUtils.isEmpty(diagnosis)) {
            return refmap;
        }
        if (diagnosis.size() != 1) {
            return refmap;
        }
        map = new JSONObject();
        map = diagnosis.get(0);


        //取入院日期
        String ryrq = Convert.toStr(map.get("ryrq"), "");
        if (babySign == 2) {
            ryrq = Convert.toStr(TransferBabyInfo.get(0).get("yecsny"), "");
        }
        int djz = Convert.toInt(data.get("djz"), 0);
        String zyrqList[] = new String[7];
        String daysAfterSick[] = new String[7];
        String daysAfterOperation[] = new String[7];
        String startTime = "";
        String endTime = "";

        for (int i = 0; i < 7; i++) {
            String ls_date = getDayBefore(ryrq, (djz - 1) * 7 + i);
            daysAfterSick[i] = Convert.toStr((djz - 1) * 7 + i + 1, "");
            if (i == 0) {
                startTime = ls_date;
            }
            endTime = ls_date;

            if (i == 0) {//&& djz == 1){ // 第一天
                zyrqList[i] = ls_date;
            } else if (ls_date.substring(0, 4) != ryrq.substring(0, 4) && ryrq.substring(5, 10).equals("01-01")) { //跨年,第一天
                zyrqList[i] = ls_date;
            } else if (ls_date.substring(8, 10).equals("01")) { //跨月//if(i== 0 || ls_date.substring(8,10).equals( "01")){ //跨月
                zyrqList[i] = ls_date.substring(5, 10);
            } else {
                zyrqList[i] = ls_date.substring(8, 10);

            }
        }

        //获取体征明细
        sql = "select cjh \"cjh\",fcgl \"fcgl\",  bzxx \"bzxx\",  (case    when fcbz=0  or fcgl is null then  xmh else 9999 end) \"xmh\"" +
                " , jhbz \"jhbz\" , to_char(cjsj, 'yyyy-MM-dd hh24:mi:ss') \"cjsj\" , zyh \"zyh\" , brks \"brks\" , brch \"brch\",\n" +
                "tznr \"tznr\" , xmxb \"xmxb\" , jlgh \"jlgh\",\n" +
                "ROUND ((TO_DATE(to_char(cjsj,'yyyy-MM-dd hh24:mi'), 'yyyy-MM-dd hh24:mi') - TO_DATE(#{startTimeH},'yyyy-MM-dd hh24:mi'))*24) \"time\"\n" +
                " from bq_smtz where zyh =#{zybah} and zfbz = 0   \n" +
                " and to_char(cjsj,'yyyy-mm-dd')>= #{startTime}\n" +
                " and to_char(cjsj,'yyyy-mm-dd')<= #{endTime} and brlx_ye = #{lx} order by cjsj ";

        data.put("startTime", startTime);
        data.put("endTime", endTime);
        data.put("startTimeH", startTime + " 00:00");
        data.put("lx", babynum);
        signData = selectList(sql, data);

        //分组
        Map<Object, List<Map<String, Object>>> signDataGroup = signData.stream().collect(Collectors.groupingBy(one -> {
            return Convert.toInt(one.get("xmh"));
        }));

        Map<Object, List<Map<String, Object>>> signDataGroupNotNum = signData.stream().collect(Collectors.groupingBy(one -> {
            int xmh = Convert.toInt(one.get("xmh"));
            if (xmh == 1 || xmh == 2 || xmh == 4) {
                String xmz = Convert.toStr(one.get("tznr"), "");
                try {
                    Double.parseDouble(xmz);

                } catch (Exception e) {
                    return 1;
                }
            }
            return 0;
        }));

        //体温，补全，外出/拒测数据/排序
        if (StringUtils.isNotEmpty(signDataGroupNotNum.get(1))) {

            if (StringUtils.isNotEmpty(signDataGroup.get(1))) {
                for (Map<String, Object> item : signDataGroupNotNum.get(1)) {
                    item.put("xmh", "1");
                }
                signDataGroup.get(1).addAll(signDataGroupNotNum.get(1));
                signDataGroup.get(1)
                        .sort(Comparator.comparing(
                                map1 -> parseDate(Convert.toStr(map1.get("cjsj")))));
            }


            //脉搏，补全，外出/拒测数据/排序
            if (StringUtils.isNotEmpty(signDataGroup.get(2))) {
                for (Map<String, Object> item : signDataGroupNotNum.get(1)) {
                    item.put("xmh", "2");
                }
                signDataGroup.get(2).addAll(signDataGroupNotNum.get(1));
                signDataGroup.get(2)
                        .sort(Comparator.comparing(
                                map1 -> parseDate(Convert.toStr(map1.get("cjsj")))));
            }


            //脉搏，补全，外出/拒测数据/排序
            if (StringUtils.isNotEmpty(signDataGroup.get(4))) {
                for (Map<String, Object> item : signDataGroupNotNum.get(1)) {
                    item.put("xmh", "4");
                }
                signDataGroup.get(4).addAll(signDataGroupNotNum.get(1));
                signDataGroup.get(4)
                        .sort(Comparator.comparing(
                                map1 -> parseDate(Convert.toStr(map1.get("cjsj")))));
            }


        }


        map.put("date", zyrqList);//在院日期
        map.put("daysAfterSick", daysAfterSick); // 住院天数
        map.put("daysAfterOperation", daysAfterOperation); // 术后天数
        map.put("pageNumber", data.get("djz"));

        //入量
        String StatisticsSummary1[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(122))) {
            for (Map<String, Object> item : signDataGroup.get(122)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                if (StatisticsSummary1[en] == null) {
                    StatisticsSummary1[en] = Convert.toStr(item.get("tznr"), "");
                } else {
                    StatisticsSummary1[en] = StatisticsSummary1[en] + Convert.toStr(item.get("tznr"), "");
                }

            }

        }
        map.put("StatisticsSummary1", StatisticsSummary1);//入量

        //出量
        String StatisticsSummary2[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(145))) {

            for (Map<String, Object> item : signDataGroup.get(145)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                if (StatisticsSummary2[en] == null) {
                    StatisticsSummary2[en] = Convert.toStr(item.get("tznr"), "");
                } else {
                    StatisticsSummary2[en] = StatisticsSummary2[en] + Convert.toStr(item.get("tznr"), "");
                }

            }

        }
        map.put("StatisticsSummary2", StatisticsSummary2);//出量

        //尿量
        String StatisticsSummary3[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(32))) {

            for (Map<String, Object> item : signDataGroup.get(32)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                if (StatisticsSummary3[en] == null) {
                    StatisticsSummary3[en] = Convert.toStr(item.get("tznr"), "");
                } else {
                    StatisticsSummary3[en] = StatisticsSummary3[en] + Convert.toStr(item.get("tznr"), "");
                }

            }

        }
        map.put("StatisticsSummary3", StatisticsSummary3);//尿量


        //大便次数
        String shitTimes[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(31))) {

            for (Map<String, Object> item : signDataGroup.get(31)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                if (StringUtils.isEmpty(shitTimes[en])) {
                    shitTimes[en] = Convert.toStr(item.get("tznr"), "");
                } else {
                    shitTimes[en] = Convert.toStr(Convert.toInt(shitTimes[en], 0) + Convert.toInt(item.get("tznr"), 0), "");
                }

            }

        }
        map.put("shitTimes", shitTimes);//大便次数


        //身高
        String height[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(8))) {

            for (Map<String, Object> item : signDataGroup.get(8)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);

//                if (StringUtils.isEmpty(height[en])) {
                height[en] = Convert.toStr(item.get("tznr"), "");
//                } else {
//                    height[en] = Convert.toStr(Convert.toInt(height[en], 0) + Convert.toInt(item.get("tznr"), 0), "");
//                }
            }

        }
        map.put("height", height);//体重

        //体重
        String weight[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(7))) {

            for (Map<String, Object> item : signDataGroup.get(7)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);

                weight[en] = Convert.toStr(item.get("tznr"));
            }

        }
        map.put("weight", weight);//体重

        //血压
        List<List<Map<String, Object>>> tempListBloodPressure = new ArrayList<>();
        for (int i = 0; i < 7; i++) {

            List<Map<String, Object>> listBloodPressure = new ArrayList<>();
            for (int j = 0; j < 2; j++) {
                mapTemp = new JSONObject();
                mapTemp.put("index", j);
                mapTemp.put("systolic", "");
                mapTemp.put("diastolic", "");
                mapTemp.put("symbol", "");
                //i 天数 ， j 时辰
                listBloodPressure.add(mapTemp);


            }

            tempListBloodPressure.add(listBloodPressure);
        }

        if (StringUtils.isNotEmpty(signDataGroup.get(5))) {
            for (Map<String, Object> item : signDataGroup.get(5)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                int tiemNew = Convert.toInt(item.get("time")) % 24;
                if (tiemNew < 12) {
                    tempListBloodPressure.get(en).get(0).put("systolic", item.get("tznr"));
                    tempListBloodPressure.get(en).get(0).put("symbol", "/");
                } else {
                    tempListBloodPressure.get(en).get(1).put("systolic", item.get("tznr"));
                    tempListBloodPressure.get(en).get(1).put("symbol", "/");
                }

            }

        }

        if (StringUtils.isNotEmpty(signDataGroup.get(6))) {
            for (Map<String, Object> item : signDataGroup.get(6)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);
                int tiemNew = Convert.toInt(item.get("time")) % 24;
                if (tiemNew < 12) {
                    tempListBloodPressure.get(en).get(0).put("diastolic", item.get("tznr"));
                    tempListBloodPressure.get(en).get(0).put("symbol", "/");
                } else {
                    tempListBloodPressure.get(en).get(1).put("diastolic", item.get("tznr"));
                    tempListBloodPressure.get(en).get(1).put("symbol", "/");
                }

            }

        }


        map.put("bloodPressure", tempListBloodPressure);

        //卡介苗 BCG 11
        String BCG[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(11))) {

            for (Map<String, Object> item : signDataGroup.get(11)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);


                BCG[en] = Convert.toStr(item.get("tznr"), "");
            }

        }
        map.put("BCG", BCG);

        //脐况 umbilicusCondition  9
        String umbilicusCondition[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(9))) {

            for (Map<String, Object> item : signDataGroup.get(9)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);


                umbilicusCondition[en] = Convert.toStr(item.get("tznr"), "");

            }

        }
        map.put("umbilicusCondition", umbilicusCondition);

        //黄疸 jaundice 10
        String jaundice[] = new String[7];
        if (StringUtils.isNotEmpty(signDataGroup.get(10))) {

            for (Map<String, Object> item : signDataGroup.get(10)) {
                int en = Convert.toInt(Math.floor(Convert.toInt(item.get("time"), 0) / 24), 0);


                jaundice[en] = Convert.toStr(item.get("tznr"), "");

            }

        }
        map.put("jaundice", jaundice);

        refmap.put("tableData", map);
        //获取或者体征分娩日期
        //获取或者体征手术分娩日期


        //术后天数
//        int daysAfterOperation[];
//        refmap.put("daysAfterOperation",daysAfterOperation);
        /*
        List<Map<String, Object>> collect = tempList.stream().filter(temp -> {
            return true;
        }).collect(Collectors.toList());

        Map<Object, List<Map<String, Object>>> collect1 = tempList.stream().collect(Collectors.groupingBy(one -> {
            return one.get("");
        }));*/

        //绘图（表格）
        mapTemp = new JSONObject();
        map = new JSONObject();
        tempList = new ArrayList<>();
        map.put("daySplit", 6);
        map.put("TimeSplit", new String[]{"2", "6", "10", "14", "18", "22"});
        map.put("TimeSplitDate", new String[]{"上午", "下午"});

        mapTemp = new JSONObject();
        mapTemp.put("name", "体温");
        mapTemp.put("color", "blue");
        tempList.add(mapTemp);

        mapTemp = new JSONObject();
        mapTemp.put("name", "脉搏");
        mapTemp.put("color", "red");
        tempList.add(mapTemp);

        mapTemp = new JSONObject();
        mapTemp.put("name", "呼吸");
        mapTemp.put("color", "#2f1c77");
        tempList.add(mapTemp);

        map.put("legend", tempList);

        if (babySign == 2) {
            //竖坐标配置
            mapTemp = new JSONObject();
            tempList = new ArrayList<>();
            mapTemp.put("cellShowlin", (2 + painScoreNum) * babySign); //起始线
            mapTemp.put("name", "体重(g)");//
            mapTemp.put("displaySplit", 500);// 显示值递增的间隔
            mapTemp.put("cellMin", 1600); // 坐标轴最小值
            mapTemp.put("cellSplit", 100 / babySign); // 坐标轴每格代表的值
            mapTemp.put("cellMinSubtract", 400); //第一个显示值 减去值
            mapTemp.put("babySign", babySign); //婴儿标记
            // mapTemp.put("cellShowlin" , 2 + painScoreNum); //起始线
            tempList.add(mapTemp);
        } else {
            //竖坐标配置
            mapTemp = new JSONObject();
            tempList = new ArrayList<>();
            mapTemp.put("cellShowlin", (2 + painScoreNum) * babySign); //起始线
            mapTemp.put("name", "脉搏");//
            mapTemp.put("displaySplit", 20);// 显示值递增的间隔
            mapTemp.put("cellMin", emrSys.get("cellMinMb")); // 坐标轴最小值
            mapTemp.put("cellSplit", emrSys.get("cellSplitMb")); // 坐标轴每格代表的值
            mapTemp.put("cellMinSubtract", 8); //第一个显示值 减去值
            mapTemp.put("babySign", babySign); //婴儿标记
            // mapTemp.put("cellShowlin" , 2 + painScoreNum); //起始线
            tempList.add(mapTemp);
        }


        mapTemp = new JSONObject();
        mapTemp.put("cellShowlin", (2 + painScoreNum) * babySign); //起始线
        mapTemp.put("name", "体温");//
        mapTemp.put("displaySplit", 1);// 显示值递增的间隔
        mapTemp.put("cellMin", emrSys.get("cellMinTwTemperature")); // 坐标轴最小值
        mapTemp.put("cellSplit", emrSys.get("cellSplitTemperature")); // 坐标轴每格代表的值
        mapTemp.put("babySign", babySign); //婴儿标记
        mapTemp.put("cellMinSubtract", 0.4); //第一个显示值 减去值
        //mapTemp.put("cellShowlin" , 2 + painScoreNum ); //起始线
        tempList.add(mapTemp);


        map.put("yAxisData", tempList);

        refmap.put("configData", map);


        //竖向标签，只返回一周数据
        List<Map<String, Object>> listDate = new ArrayList<>();
        Map<String, Object> mapDate;


        if (babySign == 2) {
            if (StringUtils.isNotNull(TransferBabyInfo.get(0).get("yecsny"))) {
                mapDate = new JSONObject();
                mapDate.put("tag", "出生||");
                mapDate.put("data", TransferBabyInfo.get(0).get("yecsny"));
                listDate.add(mapDate);
            }
        } else {
            if (StringUtils.isNotNull(diagnosis.get(0).get("ryrq"))) {
                mapDate = new JSONObject();
                mapDate.put("tag", "入院||");
                mapDate.put("data", diagnosis.get(0).get("ryrq"));
                listDate.add(mapDate);
            }
            if (StringUtils.isNotEmpty(TransferInfo)) {
                for (Map<String, Object> item : TransferInfo) {
                    mapDate = new JSONObject();
                    mapDate.put("tag", "转科||");
                    mapDate.put("data", item.get("zksj"));
                    listDate.add(mapDate);
                }
            }
        }


        if (StringUtils.isNotNull(diagnosis.get(0).get("cyrq"))) {
            mapDate = new JSONObject();
            mapDate.put("tag", "出院||");
            mapDate.put("data", diagnosis.get(0).get("cyrq"));
            listDate.add(mapDate);
        }


        Long startTimeLen = 0L;
        //竖向时间
        //Date date = new SimpleDateFormat("yy-MM-dd").parse(startTime);
        startTimeLen = parseDate(startTime).getTime();
        for (Map<String, Object> item : listDate) {
            String text = "";
            String temp = "";
            int time = 0;

            if (parseDate(item.get("data")).getTime() >= parseDate(startTime).getTime() && parseDate(Convert.toStr(item.get("data")).substring(0, 10)).getTime() <= parseDate(endTime).getTime()) {
                time = Math.round((parseDate(item.get("data")).getTime() - startTimeLen) / (1000 * 60 * 60));
                temp = Convert.toStr(item.get("tag"), "") + getVerticalText(Convert.toStr(item.get("data"), ""));
                for (int i = 0; i < temp.length(); i++) {
                    if (i == temp.length() - 1) {
                        text += temp.substring(i, i + 1);
                    } else {
                        text += temp.substring(i, i + 1) + "\n";
                        ;
                    }

                }
                item.put("cellShowlin", painScoreNum * babySign); //起始线
                item.put("position", 42);
                item.put("cellMin", emrSys.get("cellMinTwTemperature"));
                item.put("cellSplit", emrSys.get("cellSplitTemperature"));
                item.put("type", "text");
                item.put("color", "red");
                item.put("time", time);//当前日期与确认入院日期时间差（小时数）
                item.put("text", text); //"入\n院\n|\n|\n八\n时\n五\n十\n八\n分",
            }


        }
        refmap.put("chartDataTree", listDate);

        //体温
        String BreakZ = "false";
        map = new JSONObject();
        tempList = new ArrayList<>();
        Map<String, Object> lastTemperatureTemp = new JSONObject();
        int latticeNum = 0;
        if (StringUtils.isNotEmpty(signDataGroup.get(1))) {
            for (Map<String, Object> item : signDataGroup.get(1)) {
                //删除重复占用数据
                latticeNum = deleteRepeatData(tempList, lastTemperatureTemp, latticeNum, Convert.toInt(item.get("time"), 0));
                String value = Convert.toStr(item.get("tznr"), "");
                String Break = "false";
                try {
                    //Integer.parseInt(value);
                    Double.parseDouble(value);
                    Break = "false";
                } catch (Exception e) {
                    Break = "true";

                }


                item.put("time", item.get("time"));//9
                item.put("tips", "体温" + value);
                item.put("value", value);//40
                item.put("shape", "x");

                item.put("Break", Break);//是否连线
                item.put("BreakZ", "false");//转科是否连线
                item.put("type", "temperature");

                //复测
                List<Map<String, Object>> RetestList = new ArrayList<>();
                if (StringUtils.isNotEmpty(signDataGroup.get(9999))) {
                    Map<String, Object> RetestMap;
                    for (Map<String, Object> RetestItem : signDataGroup.get(9999)) {
                        if (item.get("cjh").equals(RetestItem.get("fcgl"))) {
                            String RetestText = Convert.toStr(RetestItem.get("bzxx"), "");
                            String RetestTextList[] = RetestText.split("|");
                            if (RetestTextList.length > 0) {
                                RetestText = RetestTextList[0];
                            }
                            RetestText = RetestText + Convert.toStr(RetestItem.get("tznr"), "");

                            RetestMap = new JSONObject();
                            RetestMap.put("extra", RetestItem.get("tznr"));
                            RetestMap.put("extraColor", "red");
                            RetestMap.put("extraTips", RetestText);

                            RetestList.add(RetestMap);

                        }
                    }
                }
                item.put("extraArr", RetestList);
                //item.put("extraArr", new String[]{});
                item.put("others", new String[]{});
                lastTemperatureTemp = item;
                tempList.add(item);

            }
        }

        //转科处理
        //转科TransferInfo 不连线
        if (babySign != 2) { //婴儿不处理
            if (StringUtils.isNotEmpty(TransferInfo)) {
                for (Map<String, Object> ransferItem : TransferInfo) {
                    int TransferTime = Convert.toInt(Math.floor((parseDate(ransferItem.get("zksj")).getTime() - parseDate(startTime).getTime()) / (1000 * 60 * 60)));
                    boolean statZ = false;
                    for (Map<String, Object> item : tempList) {
                        //时间区域相同

                        if (Math.floor(TransferTime / 4) == Math.floor(Convert.toInt(item.get("time")) / 4)) {
                            item.put("BreakZ", "true");
                            statZ = true;
                        }

                        if (Math.floor(Convert.toInt(item.get("time")) / 4) > Math.floor(TransferTime / 4) && statZ == false) {
                            item.put("BreakZ", "true");
                            statZ = true;
                        }
                    }


                }
            }
        }

        map.put("cellShowlin", painScoreNum * babySign); //起始线
        map.put("cellMin", emrSys.get("cellMinTwTemperature"));
        map.put("cellSplit", emrSys.get("cellSplitTemperature"));
        map.put("array", tempList);
        map.put("type", "line");
        map.put("color", "blue");
        map.put("shape", "x-circle");
        tempList = new ArrayList<>();
        tempList.add(map);
        refmap.put("chartDataTemperature", tempList);

        //脉搏
        map = new JSONObject();
        tempList = new ArrayList<>();
        Map<String, Object> lastPulseRateTemp = new JSONObject();
        int PulseRateNum = 0;

        if (StringUtils.isNotEmpty(signDataGroup.get(2))) {
            for (Map<String, Object> item : signDataGroup.get(2)) {
                //删除重复占用数据
                PulseRateNum = deleteRepeatData(tempList, lastPulseRateTemp, PulseRateNum, Convert.toInt(item.get("time"), 0));
                String v1 = Convert.toStr(item.get("tznr"), "");
                String Break = "false";
                try {
                    //Integer.parseInt(value);
                    Double.parseDouble(v1);
                    Break = "false";
                } catch (Exception e) {
                    Break = "true";

                }

                item.put("time", item.get("time"));//9
//                item.put("v1Tips", "脉搏" + v1);
//                item.put("v1", v1);//40
                item.put("v1", v1);
                item.put("v1Tips", "脉搏" + v1);
                item.put("Break", Break);
                item.put("BreakZ", "false");//转科是否连线
                tempList.add(item);
                lastPulseRateTemp = item;
            }
        }

        //转科处理
        //转科TransferInfo 不连线
        if (StringUtils.isNotEmpty(TransferInfo)) {
            for (Map<String, Object> ransferItem : TransferInfo) {
                int TransferTime = Convert.toInt(Math.floor((parseDate(ransferItem.get("zksj")).getTime() - parseDate(startTime).getTime()) / (1000 * 60 * 60)));
                boolean statZ = false;
                for (Map<String, Object> item : tempList) {
                    //时间区域相同

                    if (Math.floor(TransferTime / 4) == Math.floor(Convert.toInt(item.get("time")) / 4)) {
                        item.put("BreakZ", "true");
                        statZ = true;
                    }

                    if (Math.floor(Convert.toInt(item.get("time")) / 4) > Math.floor(TransferTime / 4) && statZ == false) {
                        item.put("BreakZ", "true");
                        statZ = true;
                    }
                }


            }
        }

        map.put("cellShowlin", painScoreNum * babySign); //起始线
        map.put("bgColor", "rgba(255,0,0,0.7)");
        map.put("cellMin", emrSys.get("cellMinMb"));
        map.put("cellSplit", emrSys.get("cellSplitMb"));
        map.put("array", tempList);
        map.put("type", "area");
        //map.put("type" ,"line" );

        map.put("color", "red");
        map.put("shape", null);

        tempList = new ArrayList<>();
        tempList.add(map);
        refmap.put("chartDataPulse", tempList);

        //心率
        map = new JSONObject();
        tempList = new ArrayList<>();
        Map<String, Object> lastHeartRateTemp = new JSONObject();
        int heartRateNum = 0;
        if (StringUtils.isNotEmpty(signDataGroup.get(4))) {
            for (Map<String, Object> item : signDataGroup.get(4)) {
                //删除重复占用数据
                heartRateNum = deleteRepeatData(tempList, lastHeartRateTemp, heartRateNum, Convert.toInt(item.get("time"), 0));


                String v1 = Convert.toStr(item.get("tznr"), "");
                String Break = "false";
                try {
                    //Integer.parseInt(value);
                    Double.parseDouble(v1);
                    Break = "false";
                } catch (Exception e) {
                    Break = "true";

                }

                item.put("time", item.get("time"));//9
                item.put("v1Tips", "心率" + v1);
                item.put("v1", v1);//40
//                item.put("v2",v1);
//                item.put("v2Tips","脉搏" + v1);
                item.put("Break", Break);
                item.put("BreakZ", "false");//转科是否连线
                lastHeartRateTemp = item;

                tempList.add(item);
            }
        }

        //转科处理
        //转科TransferInfo 不连线
        if (StringUtils.isNotEmpty(TransferInfo)) {
            for (Map<String, Object> ransferItem : TransferInfo) {
                int TransferTime = Convert.toInt(Math.floor((parseDate(ransferItem.get("zksj")).getTime() - parseDate(startTime).getTime()) / (1000 * 60 * 60)));
                boolean statZ = false;
                for (Map<String, Object> item : tempList) {
                    //时间区域相同

                    if (Math.floor(TransferTime / 4) == Math.floor(Convert.toInt(item.get("time")) / 4)) {
                        item.put("BreakZ", "true");
                        statZ = true;
                    }

                    if (Math.floor(Convert.toInt(item.get("time")) / 4) > Math.floor(TransferTime / 4) && statZ == false) {
                        item.put("BreakZ", "true");
                        statZ = true;
                    }
                }


            }
        }

        map.put("cellShowlin", painScoreNum * babySign); //起始线
        map.put("bgColor", "rgba(255,0,0,0.7)");
        map.put("cellMin", emrSys.get("cellMinMb"));
        map.put("cellSplit", emrSys.get("cellSplitMb"));
        map.put("array", tempList);
        map.put("type", "area");
        //map.put("type" ,"line" );
        map.put("color", "red");
        map.put("shape", null);

        tempList = new ArrayList<>();
        tempList.add(map);

        refmap.put("chartDataHeartRate", tempList);

        //疼痛评分
        if (painScoreNum > 0) {
            map = new JSONObject();
            tempList = new ArrayList<>();
            Map<String, Object> lastPainScore = new JSONObject();
            int painScoreNumNew = 0;
            if (StringUtils.isNotEmpty(signDataGroup.get(510))) {
                for (Map<String, Object> item : signDataGroup.get(510)) {
                    //删除重复占用数据
                    painScoreNumNew = deleteRepeatData(tempList, lastPainScore, painScoreNumNew, Convert.toInt(item.get("time"), 0));

                    String v1 = Convert.toStr(item.get("tznr"), "");
                    String Break = "false";
//                    try{
//                        //Integer.parseInt(value);
//                        Double.parseDouble(v1);
//                        Break = "false";
//                    }
//                    catch (Exception e){
//                        Break = "true";
//
//                    }

                    item.put("time", item.get("time"));//9
                    item.put("tips", "疼痛" + v1);
                    item.put("value", v1);//40
//                item.put("v2",v1);
//                item.put("v2Tips","脉搏" + v1);
                    item.put("Break", Break);
                    item.put("BreakZ", "false");//转科是否连线
                    lastHeartRateTemp = item;

                    tempList.add(item);
                }
            }


            map.put("cellShowlin", 1); //起始线
            map.put("bgColor", "rgba(255,0,0,0.7)");
            map.put("cellMin", 0);
            map.put("cellSplit", 2);//每格代表值
            map.put("array", tempList);
            map.put("type", "tt");
            //map.put("type" ,"line" );
            map.put("color", "red");
            map.put("shape", null);

            tempList = new ArrayList<>();
            tempList.add(map);

            refmap.put("painScore", tempList);
        }


        //h呼吸
        Map<String, Object> lastBreathingDataTemp = new JSONObject();
        int breathingDataNum = 0;
        mapTemp = new JSONObject();
        for (int i = 0; i < 7; i++) {

            tempList = new ArrayList<>();


            for (int j = 0; j < 6; j++) {
                map = new JSONObject();
                map.put("xh", (i * 6) + j);
                map.put("data", "");
                map.put("stat", 1);
                tempList.add(map);
            }

            mapTemp.put(Convert.toStr(i), tempList);


        }

        if (StringUtils.isNotEmpty(signDataGroup.get(3))) {
            tempList = new ArrayList<>();
            for (Map<String, Object> item : signDataGroup.get(3)) {
                //删除重复占用数据
                breathingDataNum = deleteRepeatData(tempList, lastBreathingDataTemp, breathingDataNum, Convert.toInt(item.get("time"), 0));
                tempList.add(item);
                lastBreathingDataTemp = item;
            }

            List<Map<String, Object>> tempListTemp = new ArrayList<>();
            int breathingNum = 0;
            for (Map<String, Object> item : tempList) {
                int day = Convert.toInt(item.get("time"));
                int dayc = (int) Math.floor(day / 4);
                int dayv = Convert.toInt(Math.floor(day / 24));
                tempListTemp = new ArrayList<>();
                tempListTemp = (ArrayList) mapTemp.get(Convert.toStr(dayv));
                tempListTemp.get(dayc - dayv * 6).put("data", item.get("tznr"));


                if (breathingNum % 2 == 0) {
                    tempListTemp.get(dayc - dayv * 6).put("stat", 0);
                } else {
                    tempListTemp.get(dayc - dayv * 6).put("stat", 1);
                }
                breathingNum++;
            }


        }

        refmap.put("breathingData", mapTemp);


        //大便标记 stoolMark
        Map<String, Object> stoolMarkDataTemp = new JSONObject();
        int stoolMarkDataNum = 0;
        mapTemp = new JSONObject();
        for (int i = 0; i < 7; i++) {

            tempList = new ArrayList<>();


            for (int j = 0; j < 4; j++) {
                map = new JSONObject();
                map.put("xh", (i * 4) + j);
                map.put("data", "");
                map.put("text", "");
                map.put("stat", 1);
                tempList.add(map);
            }

            mapTemp.put(Convert.toStr(i), tempList);


        }

        if (StringUtils.isNotEmpty(signDataGroup.get(3100))) {
            tempList = new ArrayList<>();
            for (Map<String, Object> item : signDataGroup.get(3100)) {
                //删除重复占用数据
                stoolMarkDataNum = deleteRepeatData(tempList, stoolMarkDataTemp, stoolMarkDataNum, Convert.toInt(item.get("time"), 0));
                tempList.add(item);
                stoolMarkDataTemp = item;
            }

            List<Map<String, Object>> tempListTemp = new ArrayList<>();
            int breathingNum = 0;
            for (Map<String, Object> item : tempList) {
                int day = Convert.toInt(item.get("time"));
                int dayc = (int) Math.floor(day / 6);
                int dayv = Convert.toInt(Math.floor(day / 24));
                tempListTemp = new ArrayList<>();
                tempListTemp = (ArrayList) mapTemp.get(Convert.toStr(dayv));

                //大便标记 △黑； ∅褐；  ○黄；  ×绿；
                String tznrData = Convert.toStr(item.get("tznr"), "");
                String tznrDataText = "";
                if (tznrData.equals("黑")) {
                    tznrDataText = "△";
                } else if (tznrData.equals("褐")) {
                    tznrDataText = "∅";
                } else if (tznrData.equals("黄")) {
                    tznrDataText = "○";
                } else if (tznrData.equals("绿")) {
                    tznrDataText = "×";
                }
                tempListTemp.get(dayc - dayv * 4).put("data", tznrDataText);
                tempListTemp.get(dayc - dayv * 4).put("text", tznrData);


                if (breathingNum % 2 == 0) {
                    tempListTemp.get(dayc - dayv * 4).put("stat", 0);
                } else {
                    tempListTemp.get(dayc - dayv * 4).put("stat", 1);
                }
                breathingNum++;
            }

        }

        refmap.put("stoolMark", mapTemp);


        return refmap;
    }

    @Override
    public List<Map<String, Object>> getHomePageTemplate(Map<String, Object> data) {
        switchDsByDsId(Long.parseLong("9"));
        //判断首页是否存在
        String baby = Convert.toStr(data.get("baby"), "0");

        List<Map<String, Object>> homePageList = new ArrayList<>();
        String sql = "select nvl(baby,0) \"baby\" , blbh \"blbh\",blmc \"blmc\"  from  emr_bl_bl01 where jzhm=#{jzhm} and " +
                " bllb = 2000001  and mblb = #{mblb} and blzt <> 9 and nvl(baby,0) =#{baby}";
        homePageList = selectList(sql, data);

        if (StringUtils.isEmpty(homePageList)) {
            //不存在
            String zyh = Convert.toStr(data.get("jzhm"), "");
            String sxys = Convert.toStr(data.get("sxys"), "");
            String brks = Convert.toStr(data.get("brks"), "");
            String cjks = Convert.toStr(data.get("cjks"), "");
            String brxm = Convert.toStr(data.get("brxm"), "");
            String brzd = Convert.toStr(data.get("brzd"), "");
            String ssys = Convert.toStr(data.get("ssys"), "");


            sql = "select  '" + baby + "' \"baby\", '" + zyh + "' \"jzhm\" , '" + zyh + "' \"brbh\" ,(case instr(b.chtname,'中医')    when  0 then 1 else 2 end) \"dllb\"," +
                    "0 \"bllx\" ,frameworkcode \"bllb\" , templatetype \"mblb\" ,b.chtcode \"mbbh\" ,b.chtcode \"dlj\" ,b.chtname \"blmc\" ," +
                    " '' \"blzm\" , 0 \"blzt\" , 1 \"ifnew\" , xmltextpat \"blnr\"  " +
                    " , '" + sxys + "' \"sxys\" , '" + brks + "' \"brks\" , '" + cjks + "' \"cjks\" , '" + brxm + "' \"brxm\" , '" + brzd + "' \"brzd\" , '" + ssys + "' \"ssys\"" +
                    "from  chtemplate_ksdz a ,  chtemplate_dc b \n" +
                    "where b.frameworkcode = 2000001  and templatetype = #{mblb}  and\n" +
                    "   bmnbbh = #{cjks}  and a.chtcode = b.chtcode  ";
            homePageList = new ArrayList<>();
            homePageList = selectList(sql, data);
            if (StringUtils.isEmpty(homePageList)) {
                DataSourceUtil.switchDefaultDs();
                return null;
            }
            for (Map<String, Object> item : homePageList) {
                String xml = getEmrXmlDate("u8", item.get("blnr"));
                item.put("blnr", xml);
            }
            DataSourceUtil.switchDefaultDs();
            return homePageList;
//            data.put("sxys" , "");
//            data.put("brks" , "");
//            data.put("cjks" , "");
//            data.put("brxm" , 0);
//            data.put("brzd" , 0);
//            data.put("ssys" , 0);

        } else {
            sql = "select nvl(baby,0) \"baby\", blbh\"blbh\",jzhm \"jzhm\",brbh \"brbh\",bllx \"bllx\",bllb \"bllb\",\n" +
                    "mblb \"mblb\",mbbh \"mbbh\",dllb \"dllb\",dlj \"dlj\",blmc \"blmc\",\n" +
                    "blzm \"blzm\",zxsj \"zxsj\",cjsj \"cjsj\",sxys \"sxys\",brks \"brks\",\n" +
                    "cjks \"cjks\",blzt \"blzt\",brxm \"brxm\",brzd \"brzd\",ssys \"ssys\",0\"ifnew\" , " +
                    "(select xmltextpat from chtemplate_dc where chtcode = mbbh) \"blnr\" \n" +
                    "from emr_bl_bl01  where blbh = #{blbh} and blzt <> 9 and nvl(baby,0) = #{baby} ";

            List<Map<String, Object>> homePageList2 = new ArrayList<>();
            homePageList2 = selectList(sql, homePageList.get(0));
            if (StringUtils.isEmpty(homePageList2)) {
                DataSourceUtil.switchDefaultDs();
                return null;
            }
            String xmlData = getEmrXmlDate("u8", homePageList2.get(0).get("blnr"));
            homePageList2.get(0).put("blnr", xmlData);

            //获取首页明细
            if (data.get("mblb").equals(2000001)) {
                List<Map<String, Object>> homePageList3 = new ArrayList<>();
                sql = "select  glzd \"glzd\", xmqz \"xmqz\" from emr_bl_basysj where blbh =#{blbh}";
                data.put("blbh", homePageList2.get(0).get("blbh"));
                homePageList3 = selectList(sql, data);
                Map<String, Object> sjj = new JSONObject();
                for (Map<String, Object> item : homePageList3
                ) {
                    sjj.put(Convert.toStr(item.get("glzd"), ""), Convert.toStr(item.get("xmqz"), ""))
                    ;
                }

                homePageList2.add(sjj);
            } else if (data.get("mblb").equals(2000002)) {
                //附页数据
                List<Map<String, Object>> attachedSheet = new ArrayList<>();
                sql = " select * from  EMR_BL_BASYSJ_FY  where blbh = #{blbh}";
                data.put("blbh", homePageList2.get(0).get("blbh"));
                attachedSheet = selectList(sql, data);
                if (StringUtils.isEmpty(attachedSheet)) {
                    DataSourceUtil.switchDefaultDs();
                    return null;
                }

                Map<String, Object> attachedSheetMap = new JSONObject();

                for (String key : attachedSheet.get(0).keySet()) {
                    attachedSheetMap.put(key, attachedSheet.get(0).get(key));
                }
                homePageList2.add(attachedSheetMap);
            }
            DataSourceUtil.switchDefaultDs();

            return homePageList2;
        }


    }

    //大数据编码处理
    private String getEmrXmlDate(String charsetValue, Object o) {
        //有编码的做转换
        String xmlData = "";
        if (StringUtils.isEmpty(charsetValue)) {
            //返回
            return xmlData;
        }
        Blob b = (Blob) o;
        try (InputStream inputStream = b.getBinaryStream()) {
            byte[] bytes = null;
            if ("pic".equals(charsetValue)) {
                FastByteArrayOutputStream os = new FastByteArrayOutputStream();
                BufferedImage image = ImageIO.read(inputStream);
                ImageIO.write(image, "jpg", os);
                bytes = os.toByteArray();
            } else {
                //获取编码格式
                String s = IOUtils.toString(inputStream,
                        Charset.forName(DictUtils.getDictLabel("sys_charset", charsetValue)));
                s = s.replace("&gt;", ">")
                        .replace("&lt;", "<")
                        .replace("\\r\\n", "");

                //替换<Attributes></Attributes>
                String reg = "(<Attributes>)([\\s\\S]*?)(</Attributes>)";
                s = s.replaceAll(reg, "");
                bytes = s.getBytes();
            }


            xmlData = Base64.encode(bytes);

        } catch (SQLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }


        return xmlData;

    }


}
