package com.tbyf.his.platform.service.impl;


import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.platform.domain.BDataset;
import com.tbyf.his.platform.mapper.BDatasetMapper;
import com.tbyf.his.platform.service.IBDatasetService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据集 服务层实现
 *
 * @author guopx
 * @date 2020/10/19
 */
@DataSource(value = DataSourceType.SLAVE)
@Service
public class BDatasetServiceImpl implements IBDatasetService {
    @Resource
    private BDatasetMapper bDatasetMapper;


    /**
     * 查询数据集 信息集合
     *
     * @param bDataset 数据集 信息
     * @return 数据集 信息集合
     */
    @Override
    public List<BDataset> selectBDatasetList(BDataset bDataset) {
        return bDatasetMapper.selectBDatasetList(bDataset);
    }

}
