package com.tbyf.his.print.mapper;


import com.tbyf.his.print.domain.PrintMetadata;

import java.util.List;

/**
 * 数据元信息Mapper接口
 *
 * @author x
 * @date 2022-02-25
 */
public interface PrintMetadataMapper {
    /**
     * 查询数据元信息
     *
     * @param metadataId 数据元信息主键
     * @return 数据元信息
     */
    public PrintMetadata selectPrintMetadataByMetadataId(Long metadataId);

    /**
     * 查询数据元信息列表
     *
     * @param printMetadata 数据元信息
     * @return 数据元信息集合
     */
    public List<PrintMetadata> selectPrintMetadataList(PrintMetadata printMetadata);

    /**
     * 新增数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    public int insertPrintMetadata(PrintMetadata printMetadata);

    /**
     * 修改数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    public int updatePrintMetadata(PrintMetadata printMetadata);

    /**
     * 删除数据元信息
     *
     * @param metadataId 数据元信息主键
     * @return 结果
     */
    public int deletePrintMetadataByMetadataId(Long metadataId);

    /**
     * 批量删除数据元信息
     *
     * @param metadataIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePrintMetadataByMetadataIds(Long[] metadataIds);
}
