package com.tbyf.his.print.service.impl;


import com.tbyf.his.print.domain.PrintTempItem;
import com.tbyf.his.print.mapper.PrintTempItemMapper;
import com.tbyf.his.print.service.IPrintTempItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 打印模板项Service业务层处理
 *
 * @author x
 * @date 2022-02-28
 */
@Service
public class PrintTempItemServiceImpl implements IPrintTempItemService {
    @Autowired
    private PrintTempItemMapper printTempItemMapper;

    /**
     * 查询打印模板项
     *
     * @param id 打印模板项主键
     * @return 打印模板项
     */
    @Override
    public PrintTempItem selectPrintTempItemById(Long id) {
        return printTempItemMapper.selectPrintTempItemById(id);
    }

    /**
     * 查询打印模板项列表
     *
     * @param printTempItem 打印模板项
     * @return 打印模板项
     */
    @Override
    public List<PrintTempItem> selectPrintTempItemList(PrintTempItem printTempItem) {
        return printTempItemMapper.selectPrintTempItemList(printTempItem);
    }

    /**
     * 新增打印模板项
     *
     * @param printTempItem 打印模板项
     * @return 结果
     */
    @Override
    public int insertPrintTempItem(PrintTempItem printTempItem) {
        return printTempItemMapper.insertPrintTempItem(printTempItem);
    }

    /**
     * 修改打印模板项
     *
     * @param printTempItem 打印模板项
     * @return 结果
     */
    @Override
    public int updatePrintTempItem(PrintTempItem printTempItem) {
        return printTempItemMapper.updatePrintTempItem(printTempItem);
    }

    /**
     * 批量删除打印模板项
     *
     * @param ids 需要删除的打印模板项主键
     * @return 结果
     */
    @Override
    public int deletePrintTempItemByIds(Long[] ids) {
        return printTempItemMapper.deletePrintTempItemByIds(ids);
    }

    /**
     * 删除打印模板项信息
     *
     * @param id 打印模板项主键
     * @return 结果
     */
    @Override
    public int deletePrintTempItemById(Long id) {
        return printTempItemMapper.deletePrintTempItemById(id);
    }
}
