package com.tbyf.his.system.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 应用管理对象 sys_application
 *
 * @author ruoyi
 * @date 2022-03-17
 */
public class SysApplication extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 应用ID
     */
    private Long id;

    /**
     * 应用名称
     */
    @Excel(name = "应用名称")
    private String appName;

    /**
     * 厂商名称
     */
    @Excel(name = "厂商名称")
    private String manufacturerName;

    /**
     * 联系人
     */
    @Excel(name = "联系人")
    private String contacts;

    /**
     * 联系人电话
     */
    @Excel(name = "联系人电话")
    private String contactTelephone;

    /**
     * 状态(正常1  锁定0  )
     */
    @Excel(name = "状态(正常1  锁定0  )")
    private Long status;

    /**
     * 所属机构
     */
    @Excel(name = "所属机构")
    private String orgcode;

    /**
     * 是否单点登录(否0 是1)
     */
    @Excel(name = "是否单点登录(否0 是1)")
    private Long singleLogin;

    /**
     * 应用链接
     */
    @Excel(name = "应用链接")
    private String linkUrl;

    /**
     * 应用图标
     */
    @Excel(name = "应用图标")
    private String appIcon;

    private String authCode;

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContactTelephone(String contactTelephone) {
        this.contactTelephone = contactTelephone;
    }

    public String getContactTelephone() {
        return contactTelephone;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public Long getStatus() {
        return status;
    }

    public void setOrgcode(String orgcode) {
        this.orgcode = orgcode;
    }

    public String getOrgcode() {
        return orgcode;
    }

    public void setSingleLogin(Long singleLogin) {
        this.singleLogin = singleLogin;
    }

    public Long getSingleLogin() {
        return singleLogin;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public String getAppIcon() {
        return appIcon;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("appName", getAppName())
                .append("manufacturerName", getManufacturerName())
                .append("contacts", getContacts())
                .append("contactTelephone", getContactTelephone())
                .append("status", getStatus())
                .append("orgcode", getOrgcode())
                .append("singleLogin", getSingleLogin())
                .append("linkUrl", getLinkUrl())
                .append("appIcon", getAppIcon())
                .toString();
    }

}
