package com.tbyf.his.system.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.common.core.domain.TreeSelect;
import com.tbyf.his.common.core.domain.entity.SysMenu;
import com.tbyf.his.common.core.text.Convert;
import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.tree.BuildTree;
import com.tbyf.his.common.utils.tree.Tree;
import org.apache.poi.hssf.record.DVALRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.tbyf.his.system.mapper.SysModuleMapper;
import com.tbyf.his.system.domain.SysModule;
import com.tbyf.his.system.service.ISysModuleService;

/**
 * 应用模块管理Service业务层处理
 *
 * @author zq
 * @date 2022-05-30
 */
@Service
public class SysModuleServiceImpl implements ISysModuleService {
    @Autowired
    private SysModuleMapper sysModuleMapper;
    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;

    /**
     * 查询应用模块管理
     *
     * @param moduleId 应用模块管理主键
     * @return 应用模块管理
     */
    @Override
    public SysModule selectSysModuleByModuleId(Long moduleId) {
        return sysModuleMapper.selectSysModuleByModuleId(moduleId);
    }

    /**
     * 查询应用模块管理列表
     *
     * @param sysModule 应用模块管理
     * @return 应用模块管理
     */
    @Override
    public List<SysModule> selectSysModuleList(SysModule sysModule) {
        return sysModuleMapper.selectSysModuleList(sysModule);
    }

    /**
     * 新增应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    @Override
    public int insertSysModule(SysModule sysModule) {
        sysModule.setCreateTime(DateUtils.getNowDate());
        return sysModuleMapper.insertSysModule(sysModule);
    }

    /**
     * 修改应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    @Override
    public int updateSysModule(SysModule sysModule) {
        sysModule.setUpdateTime(DateUtils.getNowDate());
        return sysModuleMapper.updateSysModule(sysModule);
    }

    /**
     * 批量删除应用模块管理
     *
     * @param moduleIds 需要删除的应用模块管理主键
     * @return 结果
     */
    @Override
    public int deleteSysModuleByModuleIds(Long[] moduleIds) {
        return sysModuleMapper.deleteSysModuleByModuleIds(moduleIds);
    }

    /**
     * 删除应用模块管理信息
     *
     * @param moduleId 应用模块管理主键
     * @return 结果
     */
    @Override
    public int deleteSysModuleByModuleId(Long moduleId) {
        return sysModuleMapper.deleteSysModuleByModuleId(moduleId);
    }


    /**
     * 构建前端所需要下拉树结构
     *
     * @param modules 菜单列表
     * @return 下拉树结构列表
     */
    @Override
    public List<Tree<SysModule>> buildModuleTreeSelect(List<SysModule> modules) {
        List<Tree<SysModule>> treeList = new ArrayList<>();
        for (SysModule map : modules) {
            Tree<SysModule> mapTree = new Tree<>();
            mapTree.setId(Convert.toStr(map.getModuleId()));
            mapTree.setParentId(Convert.toStr(map.getParentId(), "0"));
            mapTree.setLabel(Convert.toStr(map.getModuleName()));
            treeList.add(mapTree);
        }
        List<Tree<SysModule>> trees = BuildTree.buildTree(treeList);
        return trees;
    }

    @Override
    public List<SysModule> buildModuleTree(List<SysModule> modules) {
        List<SysModule> returnList = new ArrayList<SysModule>();
        List<Long> tempList = new ArrayList<Long>();
        for (SysModule dept : modules) {
            tempList.add(dept.getModuleId());
        }
        for (Iterator<SysModule> iterator = modules.iterator(); iterator.hasNext(); ) {
            SysModule module = (SysModule) iterator.next();
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(Long.valueOf(module.getParentId()))) {
                recursionFn(modules, module);
                returnList.add(module);
            }
        }
        if (returnList.isEmpty()) {
            returnList = modules;
        }
        return returnList;
    }

    @Override
    public boolean hasChildByModuleId(Long moduleId) {
        String moduleIds = moduleId.toString();
        int has = sysModuleMapper.hasChildByModuleId(moduleIds);
        return has > 0 ? true : false;
    }

    /**
     * 查询需要修改的数据手否有重复的
     *
     * @param
     * @return
     */
    @Override
    public String checkMenuNameUnique(SysModule module) {
        Long moduleId = StringUtils.isNull(module.getModuleId()) ? -1L : module.getModuleId();
        System.out.println(module.getModuleName() + "0.0" + module.getParentId());
        SysModule info = sysModuleMapper.checkMenuNameUnique(module);
        return StringUtils.isNotNull(info) && info.getModuleId().equals(moduleId) ? "1" : "0";
    }

    /**
     * 查询module在树的哪一级别
     * @param sysModule
     * @return
     */
//    public int queryLevel(SysModule sysModule){
//        if ()
//    }
//
//    public void queryLevels(Long moduleId,int a){
//        SysModule module = sysModuleMapper.selectSysModuleByModuleId(moduleId);
//        if (module.getParentId()==null){
//
//        }else {
//            return module.getParentId();
//        }
//
//    }


    /**
     * 递归列表
     *
     * @param list
     * @param t
     */
    private void recursionFn(List<SysModule> list, SysModule t) {
        // 得到子节点列表
        List<SysModule> childList = getChildList(list, t);
        t.setChildren(childList);
        for (SysModule tChild : childList) {
            if (hasChild(list, tChild)) {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<SysModule> getChildList(List<SysModule> list, SysModule t) {
        List<SysModule> tlist = new ArrayList<SysModule>();
        Iterator<SysModule> it = list.iterator();
        while (it.hasNext()) {
            SysModule n = (SysModule) it.next();
            if (n.getParentId().equals(t.getModuleId().toString())) {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<SysModule> list, SysModule t) {
        return getChildList(list, t).size() > 0;
    }
}
