package com.tbyf.his.system.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;

/**
 * @author: fr
 * @date: 2022年08月04日 15:22
 */
@Service
public class SysPluginAsyncUpload {

    private static final Logger log = LoggerFactory.getLogger(SysPluginAsyncUpload.class);

    @Async
    public void uploadFile(MultipartFile file, String filePath) {
        try {
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            file.transferTo(f);
        } catch (IOException e) {
            log.error("上传{}出错，错误信息:{}", filePath, e.getMessage());
        }
    }

}
