package com.tbyf.his.tool.service.impl;

import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.tool.domain.TOrder;
import com.tbyf.his.tool.mapper.TOrderMapper;
import com.tbyf.his.tool.service.TOrderService;
import com.tbyf.his.tool.vo.TorderSearch;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Author:lph
 * Date:2022/12/1 16:10
 **/
@Service
@DataSource(value = DataSourceType.SLAVE)
public class TOrderServiceImpl implements TOrderService {
    @Resource
    TOrderMapper tOrderMapper;

    @Override
    public TableDataInfo selectOrderByParam(TorderSearch search) {
        int pageSize = search.getPageNum() * search.getPageSize();
        int pageNum = (search.getPageNum() - 1) * search.getPageSize();
        search.setPageSize(pageSize);
        search.setPageNum(pageNum);
        List<TOrder> list = tOrderMapper.selectOrderByParam(search);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setMsg("查询成功");
        rspData.setRows(list);
        rspData.setTotal(tOrderMapper.selectCount(search));
        return rspData;
    }
}
