package com.tbyf.his.web.controller.patient360;

import com.tbyf.his.closeloop.domain.CloseLoopManuInfo;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.framework.system.domain.SysOperLog;
import com.tbyf.his.patient360.domain.Patient360CountInfo;
import com.tbyf.his.patient360.domain.Patient360Info;
import com.tbyf.his.patient360.domain.Patient360MenuInfo;
import com.tbyf.his.patient360.service.Patient360Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 患者360模块
 */
@RestController()
@RequestMapping("/patient360")
public class Patient360Contorller extends BaseController {
    @Autowired
    Patient360Service patient360Service;

    /**
     * 患者360日志监控查询
     *
     * @param patient360Info
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo getPatient360Info(Patient360Info patient360Info) {
        startPage();
        if (patient360Info.getPageNum() == null || patient360Info.getPageSize() == null) {
            patient360Info.setPageSize(20L);
            patient360Info.setPageNum(1L);
        }
        List<SysOperLog> sysOperLogs = patient360Service.queryPatient360Info(patient360Info);
        return getDataTable(sysOperLogs);
    }

    /**
     * 患者360日志监控查询统计
     *
     * @param patient360Info
     * @return
     */
    @PostMapping("/getPatient360Count")
    public AjaxResult getPatient360Count(@RequestBody Patient360Info patient360Info) {
        Map<String, List<Patient360CountInfo>> patient360CountInfos = patient360Service.queryPatient360Count(patient360Info);
        return new AjaxResult(200, "成功", patient360CountInfos);
    }

    @GetMapping("/getPatient360Menu")
    public TableDataInfo getPatient360Manu(Patient360MenuInfo patient360MenuInfo) {
        List<Patient360MenuInfo> patient360MenuInfos = patient360Service.queryPatient360Menu(patient360MenuInfo);
        return getDataTable(patient360MenuInfos);
    }

    @PostMapping("/addPatient360Menu")
    public AjaxResult addPatient360Manu(@RequestBody Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Service.addPatient360Manu(patient360MenuInfo);
        return toAjax(i);
    }

    @PostMapping("/updatePatient360Menu")
    public AjaxResult updatePatient360Manu(@RequestBody Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Service.updatePatient360Manu(patient360MenuInfo);
        return toAjax(i);
    }

    @PostMapping("/delPatient360Menu")
    public AjaxResult delPatient360Menu(@RequestBody Patient360MenuInfo patient360MenuInfo) {
        int i = patient360Service.delPatient360Menu(patient360MenuInfo);
        return toAjax(i);
    }


}
