package com.tbyf.his.analysis.service.impl;

import com.tbyf.his.analysis.domain.*;
import com.tbyf.his.analysis.mapper.AnalysisMapper;
import com.tbyf.his.analysis.service.AnalysisService;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.UUID;

@Service
//@DataSource(value = DataSourceType.SLAVE)
public class AnalysisServiceImpl implements AnalysisService {
    @Autowired
    private AnalysisMapper analysisMapper;
    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;
    @Value("${manageData.dataSourceId}")
    private String dataSourceId;

    @Override
    public List<Analysis> selectAnalysisInfo(Analysis applyAnalog) {

        return analysisMapper.selectAnalysisInfo(applyAnalog);
    }

    @Override
    public int insterAnalysisInfo(Analysis analysis) {
        List<Analysis> analyses = analysisMapper.selectAnalysisInfo(analysis);
        if (!CollectionUtils.isEmpty(analyses)) {
            return 0;
        }
        analysis.setId(UUID.randomUUID().toString());
        return analysisMapper.insterAnalysisInfo(analysis);
    }

    @Override
    public int removeAnalysisInfo(List<Analysis> analysis) {
        return analysisMapper.removeAnalysisInfo(analysis);
    }

    @Override
    public List<AnalysisBusinessDataInfo> selectAnalysisBusinessData(AnalysisBusinessDataInfo analysisInfo) {
        List<AnalysisBusinessDataInfo> analysisCounts = analysisMapper.selectAnalysisDataCount();
        for (int i = 0; i < analysisCounts.size(); i++) {
            ConsistentData consistentData = new ConsistentData();
            consistentData.setStartDate(analysisInfo.getStartDate());
            consistentData.setEndDate(analysisInfo.getEndDate());
            consistentData.setDataGroupId(analysisCounts.get(i).getDatasetCode());
            List<ConsistentData> consistentDatas = selectAnalysisDataInfo(consistentData);
            String flag = "1";
            for (int j = 0; j < consistentDatas.size(); j++) {
                if (!consistentDatas.get(0).getCountNumber().equals(consistentDatas.get(j).getCountNumber())) {
                    flag = "0";
                }
            }
            analysisCounts.get(i).setFlag(flag);
        }
        switchDsByDsId(Long.parseLong(dataSourceId));
        for (int i = 0; i < analysisCounts.size(); i++) {
            analysisInfo.setDatasetCode(analysisCounts.get(i).getDatasetCode());
            AnalysisBusinessDataInfo analysis = analysisMapper.selectAnalysisBusinessData(analysisInfo);
            analysisCounts.get(i).setDatasetName(analysis.getDatasetName());
            analysisCounts.get(i).setTableName(analysis.getTableName());
            analysisCounts.get(i).setValueCode(analysis.getValueCode());
            analysisCounts.get(i).setValueName(analysis.getValueName());
        }
        DataSourceUtil.switchDefaultDs();
        return analysisCounts;
    }

    @Override
    public List<IdLabel> selectAnalysisBusinessDataTree() {
        switchDsByDsId(Long.parseLong(dataSourceId));
        return analysisMapper.selectAnalysisBusinessDataTree();
    }

    @Override
    public List<Analysis> selectAnalysisDataByGroupId(String dataGroupId) {
        return analysisMapper.selectAnalysisDataByGroupId(dataGroupId);
    }

    @Override
    public List<ConsistentData> selectAnalysisDataInfo(ConsistentData consistentData) {
        List<ConsistentData> consistentDatas = analysisMapper.selectAnalysisDataInfo(consistentData);
        return consistentDatas;
    }

    @Override
    public List<IdLabel> selectAnalysisBusinessDataTreeHaveApi() {
        return analysisMapper.selectAnalysisBusinessDataTreeHaveApi();
    }

    @Override
    public List<IdLabel> selectAnalysisBusinessDataTreeNoApi() {
        return analysisMapper.selectAnalysisBusinessDataTreeNoApi();
    }

    @Override
    public List<AnalysisBusinessDataInfo> selectAnalysisBusinessDataHaveApi(AnalysisBusinessDataInfo analysisInfo) {
        return analysisMapper.selectAnalysisBusinessDataHaveApi(analysisInfo);
    }

    @Override
    public List<AnalyMassageInfo> selectAnalysisMassageInfo(AnalyMassageInfo analyMassageInfo) {

        return analysisMapper.selectAnalysisMassageInfo(analyMassageInfo);
    }

    @Override
    public int insterAnalysisMassage(AnalyMassageInfo analyMassageInfo) {
        return analysisMapper.insterAnalysisMassage(analyMassageInfo);
    }

    @Override
    public int updateAnalysisMassage(AnalyMassageInfo analyMassageInfo) {
        return analysisMapper.updateAnalysisMassage(analyMassageInfo);
    }

    @Override
    public int removeAnalysisMassage(AnalyMassageInfo analyMassageInfo) {
        return analysisMapper.removeAnalysisMassage(analyMassageInfo);
    }

    private void switchDsByDsId(Long dsId) {
        SysDatasource ds = selectSysDatasourceByDatasourceId(dsId);
        if (StringUtils.isNotNull(ds)) {

            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//            DataSourceUtil.switchDs(ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

    }

    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId) {
        DataSourceUtil.switchDefaultDs();
        return sysDatasourceMapper.selectSysDatasourceByDatasourceId(datasourceId);
    }


}
