package com.tbyf.his.print.service;


import com.tbyf.his.print.domain.PrintMetadata;

import java.util.List;

/**
 * 数据元信息Service接口
 *
 * @author x
 * @date 2022-02-25
 */
public interface IPrintMetadataService {
    /**
     * 查询数据元信息
     *
     * @param metadataId 数据元信息主键
     * @return 数据元信息
     */
    public PrintMetadata selectPrintMetadataByMetadataId(Long metadataId);

    /**
     * 查询数据元信息列表
     *
     * @param printMetadata 数据元信息
     * @return 数据元信息集合
     */
    public List<PrintMetadata> selectPrintMetadataList(PrintMetadata printMetadata);

    /**
     * 新增数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    public int insertPrintMetadata(PrintMetadata printMetadata);

    /**
     * 修改数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    public int updatePrintMetadata(PrintMetadata printMetadata);

    /**
     * 批量删除数据元信息
     *
     * @param metadataIds 需要删除的数据元信息主键集合
     * @return 结果
     */
    public int deletePrintMetadataByMetadataIds(Long[] metadataIds);

    /**
     * 删除数据元信息信息
     *
     * @param metadataId 数据元信息主键
     * @return 结果
     */
    public int deletePrintMetadataByMetadataId(Long metadataId);
}
