package com.tbyf.his.adapter.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class AdapterPublishTask implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 发布表名称
     */
    private String publishTableName;

    /**
     * 增量字段
     */
    private String incField;

    /**
     * 增量字段类型
     */
    private String incFieldType;

    /**
     * 增量Sql
     */
    private String incSql;

    /**
     * 最后记录时间
     */
    private String lastRecordTime;

    /**
     * 状态 0启用 1停用
     */
    private String status;

    /**
     * 任务执行错误信息记录
     */
    private String errorInfo;

    /**
     * 数据源id
     */
    private String sourceName;
}
