package com.tbyf.his.apiconvert.mapper;

import com.tbyf.his.apiconvert.domain.FieldMap;
import com.tbyf.his.apiconvert.domain.model.SourceAndTarget;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 字段映射 数据层
 *
 * @author guopx
 */
public interface FieldMappingMapper {
    /**
     * 查询字段管理数据
     *
     * @param field 字段信息
     * @return 字段信息集合
     */
    public List<FieldMapping> selectFieldList(FieldMapping field);

    public List<FieldMapping> selectConnectTo(FieldMapping field);

    /**
     * 根据字段ID查询信息
     *
     * @param fieldId 字段ID
     * @return 字段信息
     */
    public FieldMapping selectFieldById(Long fieldId);

    /**
     * 根据ID查询所有子字段
     *
     * @param fieldId 字段ID
     * @return 字段列表
     */
    public List<FieldMapping> selectChildrenFieldById(Long fieldId);

    /**
     * 根据ID查询所有子字段（正常状态）
     *
     * @param fieldId 字段ID
     * @return 子字段数
     */
    public int selectNormalChildrenFieldById(Long fieldId);

    /**
     * 是否存在子节点
     *
     * @param fieldId 字段ID
     * @return 结果
     */
    public int hasChildByFieldId(Long fieldId);

    /**
     * 校验字段名称是否唯一
     *
     * @param fieldName 字段名称
     * @param parentId  父字段ID
     * @return 结果
     */
    public FieldMapping checkFieldNameUnique(@Param("apiId") Long apiId,
                                             @Param("fieldName") String fieldName,
                                             @Param("parentId") Long parentId,
                                             @Param("paramFlag") String paramFlag,
                                             @Param("fieldFlag") String fieldFlag
    );

    /**
     * 新增字段信息
     *
     * @param field 字段信息
     * @return 结果
     */
    public int insertField(FieldMapping field);

    /**
     * 修改字段信息
     *
     * @param field 字段信息
     * @return 结果
     */
    public int updateField(FieldMapping field);

    /**
     * 修改子元素关系
     *
     * @param fields 子元素
     * @return 结果
     */
    public int updateFieldChildren(@Param("fields") List<FieldMapping> fields);

    /**
     * 删除字段管理信息
     *
     * @param fieldId 字段ID
     * @return 结果
     */
    public int deleteFieldById(Long fieldId);

    public int insertFieldMap(FieldMap field);

    public int deleteFieldMap(@Param("sourceFieldId") Long sourceFieldId,
                              @Param("targetFieldId") Long targetFieldId,
                              @Param("apiBaseinfoId") Long apiBaseinfoId);

    public int deleteFieldMappingByApiId(@Param("apiId") Long apiId);

    List<FieldMap> selectFieldMappingByApiId(@Param("apiId") Long apiId);

    List<SourceAndTarget> selectSourceAndTargetByApiId(@Param("apiId") Long apiId);
}
