package com.tbyf.his.web.dataImport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "新增字典", description = "新增字典")
public class AddDictParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字典类型")
    @NotBlank(message = "字典类型不能为空")
    private String type;

    @ApiModelProperty(value = "展示")
    @NotBlank(message = "字典标签不能为空")
    private String label;

    @ApiModelProperty(value = "数据值")
    @NotBlank(message = "字典值不能为空")
    private String value;

    @ApiModelProperty(value = "备注")
    private String remarks;

}
