package com.tbyf.his.web.dataImport.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.vo.CreateFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.DataFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataField;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.entity.MetaField;
import com.tbyf.his.web.dataImport.mapper.DataFieldMapper;
import com.tbyf.his.web.dataImport.service.DataFieldService;
import com.tbyf.his.web.dataImport.service.DataTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RegExUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class DataFieldServiceImpl extends ServiceImpl<DataFieldMapper, DataField> implements DataFieldService {

    @Autowired
    private DataFieldMapper dataFieldMapper;

    @Autowired
    private DataTemplateService dataTemplateService;

    @Override
    public Page<DataFieldVO> queryField(QueryFieldParam param) {
        final Page<DataFieldVO> page = Page.of(param.getPageNum(), param.getPageSize());
        // 查询需要对比的信息
        final DataTemplate template = dataTemplateService.getById(param.getTemplateId());
        if (template != null) {
            final DataTemplate dataTemplate = dataTemplateService.getOne(Wrappers.lambdaQuery(DataTemplate.class)
                    .eq(DataTemplate::getOrgName, template.getOrgName())
                    .lt(DataTemplate::getYear, template.getYear())
                    .orderByDesc(DataTemplate::getYear), false);
            if (dataTemplate != null) {
                param.setOldTemplateId(dataTemplate.getId());
            }
        }
        return (Page<DataFieldVO>) dataFieldMapper.queryField(page, param);
    }

    @Override
    public void fieldMatch(DataField field, List<DataField> fieldMatchList) {
        if (StringUtils.isBlank(field.getTitle())) {
            return;
        }
        Optional<DataField> fieldOptional = fieldMatchList.stream().filter(item -> {
            // 1.先判断两个是否相等
            if (StringUtils.equals(item.getTitle().trim(), field.getTitle().trim())) {
                return true;
            }
            // 去除五角星号再判断
            return StringUtils.equals(item.getTitle().replaceAll("★","").replaceAll("：","").trim(),
                    field.getTitle().replaceAll("★","").replaceAll("：","").trim());
        }).findFirst();
        fieldOptional.ifPresent(f ->{
            field.setField(f.getField());
        });
    }

    @Override
    public List<DataField> listFieldMatchList(String templateId) {
        return dataFieldMapper.listFieldMatchList(templateId);
    }

    @Override
    public List<CreateFieldVO> getCreateFields(String templateId) {
        return dataFieldMapper.getCreateFields(templateId);
    }

    @Override
    public List<VerifyVO> getFieldsInfo(List<String> fieldList, String templateId) {
        return dataFieldMapper.getFieldsInfo(fieldList, templateId);
    }
}
