package com.tbyf.his.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.ExceptionUtil;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import com.tbyf.his.system.vo.DynamicSqlData;
import com.tbyf.his.system.vo.SqlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @Auther: fanr
 * @Date: 2022/8/26 16:53
 */
@Service
public class SysDatasourceServiceTransactional {

    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;

    private static final Logger log = LoggerFactory.getLogger(SysDatasourceServiceTransactional.class);


    @Transactional(rollbackFor = Exception.class)
    public void saveBatch(List<DynamicSqlData> list, Boolean isCover, SysDatasource ds) {
        // 只存在新增操作，覆盖的话就将表数据都清理
        if (isCover) {
            String deleteAllSql = String.format(SqlHandler.DELETE_TABLE_ALL_DATA, list.iterator().next().getTableName());
            log.info("覆盖上传，清理表书友数据:{}", deleteAllSql);
            sysDatasourceMapper.executeDDL(deleteAllSql);
        }

        int i = 0;
        for (DynamicSqlData dynamicSqlData : list) {
            try {
                i++;
                boolean isOracle = SqlHandler.isOracle(ds.getDriverClass());
                if (isOracle
                        && null == dynamicSqlData.getPrimaryParam()
                        && !SqlHandler.ORACLE_PRIMARY_KEY_ALIAS.equals(dynamicSqlData.getPrimaryKey())) {
                    // 仅仅新增的时候，并且有设置主键的时候，查询数据库主键字段对应值是否存在
                    MyKeyValue myKeyValue = dynamicSqlData.getDataParam().stream().filter(d -> dynamicSqlData.getPrimaryKey().equals(d.getKey())).findFirst().get();
                    String selectSql = String.format("select %s DATA from %s where %s = '%s'",
                            dynamicSqlData.getPrimaryKey(), dynamicSqlData.getTableName(), myKeyValue.getKey(), myKeyValue.getValue());
                    List<Map<String, Object>> maps = sysDatasourceMapper.executeSql(selectSql);
                    if (!CollectionUtils.isEmpty(maps)) {
                        throw new ServiceException("该主键对应数据已存在");
                    }
                }

                if (isOracle
                        && null != dynamicSqlData.getPrimaryParam()
                        && SqlHandler.ORACLE_PRIMARY_KEY_ALIAS.equals(dynamicSqlData.getPrimaryKey())) {
                    // 编辑并且没有设置主键的时候，不饿能用别名去更新了，得用rowid
                    MyKeyValue myKeyValue = new MyKeyValue();
                    myKeyValue.setKey(SqlHandler.ORACLE_PRIMARY_KEY);
                    myKeyValue.setValue(dynamicSqlData.getPrimaryParam().getValue());
                    dynamicSqlData.setPrimaryParam(myKeyValue);
                }

                String saveSql = null == dynamicSqlData.getPrimaryParam()
                        ? SqlHandler.createInsertSql(dynamicSqlData.getTableName(), dynamicSqlData.getDataParam())
                        : SqlHandler.createUpdateSql(dynamicSqlData.getTableName(), dynamicSqlData.getDataParam(), dynamicSqlData.getPrimaryParam());
                log.info("批量保存第{}行参数:{} - {} , 创建sql为:{}", i, JSON.toJSONString(ds), JSON.toJSONString(dynamicSqlData), saveSql);
                sysDatasourceMapper.executeDDL(saveSql);
            } catch (Exception e) {
                log.error("批量保存第{}行出错，错误信息:{}", i, ExceptionUtil.getExceptionMessage(e));

                throw new ServiceException("批量保存第" + i + "行出错");
            }
        }
    }

}
