package com.tbyf.his.web.controller.configuration;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.configuration.service.IDqConfigService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.configuration.domain.DqConfig;
import com.tbyf.his.configuration.service.IDqConfigService;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * DynamicQuery组件配置Controller
 *
 * @author guopx
 * @date 2022-05-18
 */
@RestController
@RequestMapping("/configuration/config")
public class DqConfigController extends BaseController {
    @Autowired
    private IDqConfigService dqConfigService;

    /**
     * 查询DynamicQuery组件配置列表
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:list')")
    @GetMapping("/list")
    public TableDataInfo list(DqConfig dqConfig) {
        startPage();
        List<DqConfig> list = dqConfigService.selectDqConfigList(dqConfig);
        return getDataTable(list);
    }

    /**
     * 导出DynamicQuery组件配置列表
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:export')")
    @Log(title = "DynamicQuery组件配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, DqConfig dqConfig) {
        List<DqConfig> list = dqConfigService.selectDqConfigList(dqConfig);
        ExcelUtil<DqConfig> util = new ExcelUtil<DqConfig>(DqConfig.class);
        util.exportExcel(response, list, "DynamicQuery组件配置数据");
    }

    /**
     * 获取DynamicQuery组件配置详细信息
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(dqConfigService.selectDqConfigById(id));
    }

    /**
     * 新增DynamicQuery组件配置
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:add')")
    @Log(title = "DynamicQuery组件配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DqConfig dqConfig) {
        return toAjax(dqConfigService.insertDqConfig(dqConfig));
    }

    /**
     * 修改DynamicQuery组件配置
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:edit')")
    @Log(title = "DynamicQuery组件配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DqConfig dqConfig) {
        return toAjax(dqConfigService.updateDqConfig(dqConfig));
    }

    /**
     * 删除DynamicQuery组件配置
     */
//    @PreAuthorize("@ss.hasPermi('configuration:config:remove')")
    @Log(title = "DynamicQuery组件配置", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(dqConfigService.deleteDqConfigByIds(ids));
    }
}
