package com.tbyf.his.web.dataImport.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.vo.DataFieldVO;
import com.tbyf.his.web.dataImport.entity.DataField;
import com.tbyf.his.web.dataImport.entity.MetaField;

import java.util.List;

/**
 * @author lzz
 * @date 2023/2/7 11:23
 */

public interface DataFieldService extends IService<DataField> {

    /**
     * 字段列表查询
     *
     * @param param
     * @return
     */
    Page<DataFieldVO> queryField(QueryFieldParam param);

    /**
     * 字段匹配
     *
     * @param list
     * @param field
     * @param fieldMatchList
     */
    void fieldMatch(List<MetaField> list, DataField field, List<DataField> fieldMatchList);

    /**
     * 获取待匹配的字段
     *
     * @return
     */
    List<DataField> listFieldMatchList(String templateId);

}
