package com.tbyf.his.configuration.service;

import com.tbyf.his.configuration.domain.ImportParam;
import com.tbyf.his.configuration.domain.WsConfigDetail;

import java.util.List;
import java.util.Map;

/**
 * detailService接口
 *
 * @author guopx
 * @date 2022-04-15
 */
public interface IWsConfigDetailService {
    /**
     * 查询detail
     *
     * @param id detail主键
     * @return detail
     */
    public WsConfigDetail selectWsConfigDetailById(Long id);

    /**
     * 查询detail列表
     *
     * @param wsConfigDetail detail
     * @return detail集合
     */
    public List<WsConfigDetail> selectWsConfigDetailList(WsConfigDetail wsConfigDetail);

    /**
     * 新增detail
     *
     * @param wsConfigDetail detail
     * @return 结果
     */
    public int insertWsConfigDetail(WsConfigDetail wsConfigDetail);

    /**
     * 修改detail
     *
     * @param wsConfigDetail detail
     * @return 结果
     */
    public int updateWsConfigDetail(WsConfigDetail wsConfigDetail);

    /**
     * 批量删除detail
     *
     * @param ids 需要删除的detail主键集合
     * @return 结果
     */
    public int deleteWsConfigDetailByIds(Long[] ids);

    /**
     * 删除detail信息
     *
     * @param id detail主键
     * @return 结果
     */
    public int deleteWsConfigDetailById(Long id);

    List<Map<String, Object>> importTargetKey(ImportParam importParam);

    void addDetailList(Long wsConfigId, String xmlFlag, List<WsConfigDetail> detailList);

    void updateDetailList(List<WsConfigDetail> detailList);
}
