package com.tbyf.his.system.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 结构_说明对象 sys_bjg_table
 *
 * @author guopx
 * @date 2022-05-12
 */
public class SysBjgTable extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 表名称
     */
    private String tabName;

    /**
     * 表类型(CO_MLLR.LXID=275)
     */
    @Excel(name = "表类型(CO_MLLR.LXID=275)")
    private String tabType;

    /**
     * 是否重点表(0否\1是)
     */
    @Excel(name = "是否重点表(0否\1是)")
    private String whtrPosheet;

    /**
     * 是否作废(0否\1是)
     */
    @Excel(name = "是否作废(0否\1是)")
    private String whtrCaceti;

    /**
     * 排序号
     */
    @Excel(name = "排序号")
    private Long serNum;

    /**
     * 表中文名称
     */
    @Excel(name = "表中文名称")
    private String tabCn;

    /**
     * 机构代码
     */
    @Excel(name = "机构代码")
    private String intiId;

    /**
     * 每个字段对应的英文名称
     */
    @Excel(name = "每个字段对应的英文名称")
    private String fieldEng;

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTabName() {
        return tabName;
    }

    public void setTabType(String tabType) {
        this.tabType = tabType;
    }

    public String getTabType() {
        return tabType;
    }

    public void setWhtrPosheet(String whtrPosheet) {
        this.whtrPosheet = whtrPosheet;
    }

    public String getWhtrPosheet() {
        return whtrPosheet;
    }

    public void setWhtrCaceti(String whtrCaceti) {
        this.whtrCaceti = whtrCaceti;
    }

    public String getWhtrCaceti() {
        return whtrCaceti;
    }

    public void setSerNum(Long serNum) {
        this.serNum = serNum;
    }

    public Long getSerNum() {
        return serNum;
    }

    public void setTabCn(String tabCn) {
        this.tabCn = tabCn;
    }

    public String getTabCn() {
        return tabCn;
    }

    public void setIntiId(String intiId) {
        this.intiId = intiId;
    }

    public String getIntiId() {
        return intiId;
    }

    public void setFieldEng(String fieldEng) {
        this.fieldEng = fieldEng;
    }

    public String getFieldEng() {
        return fieldEng;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("tabName", getTabName())
                .append("tabType", getTabType())
                .append("whtrPosheet", getWhtrPosheet())
                .append("whtrCaceti", getWhtrCaceti())
                .append("serNum", getSerNum())
                .append("tabCn", getTabCn())
                .append("intiId", getIntiId())
                .append("fieldEng", getFieldEng())
                .toString();
    }
}
