package com.tbyf.his.web.controller.dataImport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.web.dataImport.domain.param.AddDictParam;
import com.tbyf.his.web.dataImport.domain.param.UpdateDictParam;
import com.tbyf.his.web.dataImport.entity.DataDict;
import com.tbyf.his.web.dataImport.service.DataDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/16 15:30
 */
@RestController
@Api(tags = "字典接口")
@RequestMapping("/data/dict")
@Slf4j
public class DictDataController {

    @Autowired
    private DataDictService dictService;

    @IgnoreWebSecurity
    @GetMapping("")
    @ApiOperation("字典查询")
    public AjaxResult queryDict(@RequestParam String type) {
        final LambdaQueryWrapper<DataDict> wrapper = Wrappers.lambdaQuery(DataDict.class)
                .eq(DataDict::getType, type);
        final List<Map<String, String>> list = dictService.list(wrapper).stream().map(item -> {
            String json = item.getRemarks();
            item.setRemarks(null);
            final Map<String, String> map = BeanUtils.getFieldValueMap(item);
            if (StringUtils.isNotBlank(json)) {
                try {
                    final JSONObject object = JSON.parseObject(json);
                    object.forEach((key, value) -> {
                        map.put(key, (String) value);
                    });
                } catch (Exception ignore) {
                }
            }
            return map;
        }).collect(Collectors.toList());
        return AjaxResult.success(list);
    }

    @IgnoreWebSecurity
    @PostMapping("")
    @ApiOperation("新增字典")
    public AjaxResult addDict(@RequestBody AddDictParam param) {
        DataDict dict = new DataDict();
        BeanUtils.copyProperties(param, dict);
        dictService.save(dict);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PostMapping("/update")
    @ApiOperation("修改字典")
    public AjaxResult updateDict(@RequestBody @Validated UpdateDictParam param) {
        DataDict template = new DataDict();
        BeanUtils.copyProperties(param, template);
        dictService.updateById(template);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/delete")
    @ApiOperation("删除字典")
    public AjaxResult deleteDict(@RequestParam String dictId) {
        dictService.removeById(dictId);
        return AjaxResult.success();
    }

}
