package com.tbyf.his.web.dataImport.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.vo.CreateFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.DataFieldVO;
import com.tbyf.his.web.dataImport.entity.DataField;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lzz
 * @date 2023/2/7 11:22
 */

public interface DataFieldMapper extends BaseMapper<DataField> {

    /**
     * 查询字段
     *
     * @param page
     * @param param
     * @return
     */
    IPage<DataFieldVO> queryField(@Param("page") IPage<DataFieldVO> page, @Param("param") QueryFieldParam param);

    /**
     * 查询待匹配的其它年份的字段
     *
     * @param templateId
     * @return
     */
    List<DataField> listFieldMatchList(String templateId);

    /**
     * 查询指定模板可以用于建表的字段
     *
     * @param templateId
     * @return
     */
    List<CreateFieldVO> getCreateFields(String templateId);
}
