package com.tbyf.his.web.controller.system;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.system.domain.SysDictShowhidecolumn;
import com.tbyf.his.system.service.ISysDictShowhidecolumnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 字典显隐藏操作Controller
 *
 * @author guopx
 * @date 2022-03-25
 */
@RestController
@RequestMapping("/system/showhidecolumn")
public class SysDictShowhidecolumnController extends BaseController {
    @Autowired
    private ISysDictShowhidecolumnService sysDictShowhidecolumnService;

    /**
     * 查询字典显隐藏操作列表
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysDictShowhidecolumn sysDictShowhidecolumn) {
        startPage();
        List<SysDictShowhidecolumn> list = sysDictShowhidecolumnService.selectSysDictShowhidecolumnList(sysDictShowhidecolumn);
        return getDataTable(list);
    }

    /**
     * 导出字典显隐藏操作列表
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:export')")
    @Log(title = "字典显隐藏操作", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysDictShowhidecolumn sysDictShowhidecolumn) {
        List<SysDictShowhidecolumn> list = sysDictShowhidecolumnService.selectSysDictShowhidecolumnList(sysDictShowhidecolumn);
        ExcelUtil<SysDictShowhidecolumn> util = new ExcelUtil<SysDictShowhidecolumn>(SysDictShowhidecolumn.class);
        util.exportExcel(response, list, "字典显隐藏操作数据");
    }

    /**
     * 获取字典显隐藏操作详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(sysDictShowhidecolumnService.selectSysDictShowhidecolumnById(id));
    }

    /**
     * 新增字典显隐藏操作
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:add')")
    @Log(title = "字典显隐藏操作", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysDictShowhidecolumn sysDictShowhidecolumn) {
        return toAjax(sysDictShowhidecolumnService.insertSysDictShowhidecolumn(sysDictShowhidecolumn));
    }

    /**
     * 修改字典显隐藏操作
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:edit')")
    @Log(title = "字典显隐藏操作", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysDictShowhidecolumn sysDictShowhidecolumn) {
        return toAjax(sysDictShowhidecolumnService.updateSysDictShowhidecolumn(sysDictShowhidecolumn));
    }

    /**
     * 删除字典显隐藏操作
     */
    @PreAuthorize("@ss.hasPermi('system:showhidecolumn:remove')")
    @Log(title = "字典显隐藏操作", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(sysDictShowhidecolumnService.deleteSysDictShowhidecolumnByIds(ids));
    }
}
